/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XTabControllerModel;
import com.sun.star.drawing.XControlShape;
import com.sun.star.form.XForm;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.view.XControlAccess;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.WriterTools;
import util.utils;

public class TabController
extends TestCase {
    private static XTextDocument xTextDoc = null;

    @Override
    protected void initialize(TestParameters param, PrintWriter log) {
        try {
            log.println("creating a textdocument");
            xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)param.getMSF());
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters param, PrintWriter log) {
        log.println("disposing xTextDoc");
        DesktopTools.closeDoc(xTextDoc);
    }

    @Override
    public TestEnvironment createTestEnvironment(TestParameters param, PrintWriter log) {
        XInterface oObj = null;
        XControl xCtrl1 = null;
        XTabControllerModel tabCtrlModel = null;
        XControlContainer aCtrlContainer = null;
        FormTools.insertForm(xTextDoc, FormTools.getForms(WriterTools.getDrawPage(xTextDoc)), "MyForm");
        XControlShape aShape = FormTools.createUnoControlShape(xTextDoc, 3000, 4500, 15000, 10000, "CommandButton", "UnoControlButton");
        WriterTools.getDrawPage(xTextDoc).add(aShape);
        XControlModel model = aShape.getControl();
        XControlAccess access = UnoRuntime.queryInterface(XControlAccess.class, (Object)xTextDoc.getCurrentController());
        try {
            xCtrl1 = access.getControl(model);
        }
        catch (Exception e) {
            // empty catch block
        }
        XForm form = null;
        try {
            form = (XForm)AnyConverter.toObject((Type)new Type(XForm.class), (Object)FormTools.getForms(WriterTools.getDrawPage(xTextDoc)).getByName("MyForm"));
        }
        catch (Exception e) {
            log.println("Couldn't get Form");
            e.printStackTrace(log);
        }
        tabCtrlModel = UnoRuntime.queryInterface(XTabControllerModel.class, form);
        aCtrlContainer = UnoRuntime.queryInterface(XControlContainer.class, xCtrl1.getContext());
        try {
            oObj = (XInterface)((XMultiServiceFactory)param.getMSF()).createInstance("com.sun.star.awt.TabController");
        }
        catch (Exception e) {
            // empty catch block
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        String objName = "TabController";
        tEnv.addObjRelation("OBJNAME", "toolkit." + objName);
        tEnv.addObjRelation("MODEL", tabCtrlModel);
        tEnv.addObjRelation("CONTAINER", aCtrlContainer);
        System.out.println("ImplementationName: " + utils.getImplName(oObj));
        return tEnv;
    }
}

