/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.awt.tree.XMutableTreeDataModel;
import com.sun.star.awt.tree.XMutableTreeNode;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.awt.tree._XMutableTreeNode;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.utils;

public class MutableTreeNode
extends TestCase {
    private static XTextDocument xTextDoc;
    private static XInterface oObj;
    private static XMutableTreeDataModel mXTreeDataModel;
    private static XMultiServiceFactory mxMSF;
    private static PrintWriter log;
    private static boolean debug;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        MutableTreeNode.log = log;
        debug = tParam.getBool("DebugIsActive");
        mxMSF = (XMultiServiceFactory)tParam.getMSF();
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(xTextDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        try {
            mXTreeDataModel = UnoRuntime.queryInterface(XMutableTreeDataModel.class, mxMSF.createInstance("com.sun.star.awt.tree.MutableTreeDataModel"));
        }
        catch (Exception ex) {
            throw new StatusException(Status.failed("ERROR: could not create instance of 'com.sun.star.awt.tree.MutableTreeDataModel'"));
        }
        XMutableTreeNode xNode = mXTreeDataModel.createNode("UnoTreeControl", false);
        String sDisplayValue = "UnoTreeControl";
        String sExpandedGraphicURL = "private:graphicrepository/sd/res/triangle_down.png";
        String sCollapsedGraphicURL = "private:graphicrepository/sd/res/triangle_right.png";
        String sNodeGraphicURL = "private:graphicrepository/sw/imglst/nc20010.png";
        xNode.setDisplayValue(sDisplayValue);
        xNode.setDataValue(sDisplayValue);
        xNode.setExpandedGraphicURL(sExpandedGraphicURL);
        xNode.setCollapsedGraphicURL(sCollapsedGraphicURL);
        xNode.setNodeGraphicURL(sNodeGraphicURL);
        xNode.setHasChildrenOnDemand(true);
        this.fillNode(xNode);
        TestEnvironment tEnv = new TestEnvironment(xNode);
        tEnv.addObjRelation("OBJNAME", "toolkit.MutableTreeDataModel");
        log.println("ImplementationName: " + utils.getImplName(oObj));
        tEnv.addObjRelation("XTreeNode_DisplayValue", sDisplayValue);
        tEnv.addObjRelation("XTreeNode_ExpandedGraphicURL", sExpandedGraphicURL);
        tEnv.addObjRelation("XTreeNode_CollapsedGraphicURL", sCollapsedGraphicURL);
        tEnv.addObjRelation("XTreeNode_NodeGraphicURL", sNodeGraphicURL);
        tEnv.addObjRelation("XMutableTreeNode_NodeToAppend", mXTreeDataModel.createNode("XMutableTreeNode_NodeToAppend", true));
        tEnv.addObjRelation("XMutableTreeNodeCreator", new _XMutableTreeNode.XMutableTreeNodeCreator(){

            @Override
            public XMutableTreeNode createNode(String name) {
                return mXTreeDataModel.createNode(name, true);
            }
        });
        return tEnv;
    }

    private void fillNode(XMutableTreeNode xNode) {
        if (xNode.getChildCount() == 0) {
            String sParentPath = (String)xNode.getDataValue();
            String officeUserPath = utils.getOfficeUserPath(mxMSF);
            Object fileacc = null;
            try {
                fileacc = mxMSF.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            XSimpleFileAccess sA = UnoRuntime.queryInterface(XSimpleFileAccess.class, fileacc);
            this.dirlist(officeUserPath, xNode);
        }
    }

    private void dirlist(String dir, XMutableTreeNode xNode) {
        Object fileacc = null;
        try {
            fileacc = mxMSF.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        XSimpleFileAccess sfa = UnoRuntime.queryInterface(XSimpleFileAccess.class, fileacc);
        XMutableTreeNode xChildNode = null;
        try {
            xChildNode = mXTreeDataModel.createNode(dir.substring(dir.lastIndexOf("/") + 1, dir.length()), sfa.isFolder(dir));
            xChildNode.setDataValue(dir);
            boolean test = sfa.isFolder(dir);
            if (sfa.isFolder(dir)) {
                xChildNode.setExpandedGraphicURL("private:graphicrepository/sd/res/triangle_down.png");
                xChildNode.setCollapsedGraphicURL("private:graphicrepository/sd/res/triangle_right.png");
                String[] children = sfa.getFolderContents(dir, true);
                if (children != null) {
                    for (int i = 0; i < children.length; ++i) {
                        String filename = children[i];
                        this.dirlist(filename, xChildNode);
                    }
                }
            } else {
                xChildNode.setNodeGraphicURL("private:graphicrepository/sw/imglst/nc20010.png");
            }
        }
        catch (CommandAbortedException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            xNode.appendChild(xChildNode);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
    }

    static {
        oObj = null;
        debug = false;
    }
}

