/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.UITools;
import util.dbg;
import util.utils;

public class AccessibleToolBox
extends TestCase {
    private static XDesktop the_Desk;
    private static XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        the_Desk = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)Param.getMSF()));
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xTextDoc");
        if (xTextDoc != null) {
            DesktopTools.closeDoc(xTextDoc);
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        log.println("creating a test environment");
        if (xTextDoc != null) {
            DesktopTools.closeDoc(xTextDoc);
        }
        XMultiServiceFactory msf = (XMultiServiceFactory)tParam.getMSF();
        SOfficeFactory SOF = SOfficeFactory.getFactory(msf);
        try {
            log.println("creating a text document");
            xTextDoc = SOF.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)xTextDoc);
        XAccessibleContext oObj = null;
        UITools oUI = new UITools(msf, aModel);
        XWindow xWindow = null;
        try {
            xWindow = oUI.getActiveTopWindow();
        }
        catch (Exception ex) {
            ex.printStackTrace(log);
            throw new StatusException("Couldn't get active top window", ex);
        }
        AccessibilityTools at = new AccessibilityTools();
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(log, xRoot, tParam.getBool("DebugIsActive"));
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)63);
        log.println("ImplementationName: " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("LimitedBounds", "yes");
        XAccessible acc = AccessibilityTools.getAccessibleObject(oObj);
        XAccessible child = null;
        try {
            child = acc.getAccessibleContext().getAccessibleChild(0);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        dbg.printInterfaces(child);
        final XAccessibleAction action = UnoRuntime.queryInterface(XAccessibleAction.class, (Object)child);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                try {
                    action.doAccessibleAction(0);
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("Couldn't fire event");
                }
            }
        });
        return tEnv;
    }
}

