/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleTabControl
extends TestCase {
    private static XDesktop the_Desk;
    private static XTextDocument xTextDoc;
    private static XAccessibleAction accCloseButton;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        the_Desk = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)Param.getMSF()));
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        try {
            if (accCloseButton != null) {
                log.println("closing InsertFields Dialog");
                accCloseButton.doAccessibleAction(0);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
        }
        log.println("disposing xTextDoc");
        if (xTextDoc != null) {
            DesktopTools.closeDoc(xTextDoc);
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        log.println("creating a test environment");
        if (xTextDoc != null) {
            DesktopTools.closeDoc(xTextDoc);
        }
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a text document");
            xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        this.shortWait();
        XModel aModel1 = UnoRuntime.queryInterface(XModel.class, (Object)xTextDoc);
        XController secondController = aModel1.getCurrentController();
        XDispatchProvider aProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)secondController);
        XURLTransformer urlTransf = null;
        try {
            XInterface transf = (XInterface)((XMultiServiceFactory)tParam.getMSF()).createInstance("com.sun.star.util.URLTransformer");
            urlTransf = UnoRuntime.queryInterface(XURLTransformer.class, (Object)transf);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create URLTransformer", e);
        }
        XDispatch getting = null;
        log.println("opening InsertField dialog");
        URL[] url = new URL[]{new URL()};
        url[0].Complete = ".uno:InsertField";
        urlTransf.parseStrict(url);
        getting = aProv.queryDispatch(url[0], "", 0);
        PropertyValue[] noArgs = new PropertyValue[]{};
        getting.dispatch(url[0], noArgs);
        this.shortWait();
        XInterface oObj = null;
        try {
            oObj = (XInterface)((XMultiServiceFactory)tParam.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)oObj);
        AccessibilityTools at = new AccessibilityTools();
        this.shortWait();
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)tk.getActiveTopWindow());
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)39);
        XAccessibleContext closeButton = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)44, "Close");
        accCloseButton = UnoRuntime.queryInterface(XAccessibleAction.class, (Object)closeButton);
        log.println("ImplementationName: " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        final XAccessibleSelection selection = UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)oObj);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                try {
                    selection.selectAccessibleChild(1);
                    selection.selectAccessibleChild(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        tEnv.addObjRelation("XAccessibleSelection.OneAlwaysSelected", new Boolean(true));
        tEnv.addObjRelation("XAccessibleSelection.multiSelection", new Boolean(false));
        return tEnv;
    }

    private void shortWait() {
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }

    static {
        accCloseButton = null;
    }
}

