/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleStatusBarItem
extends TestCase {
    private static XDesktop the_Desk;
    private static XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        the_Desk = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)Param.getMSF()));
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xTextDoc");
        if (xTextDoc != null) {
            DesktopTools.closeDoc(xTextDoc);
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        log.println("creating a test environment");
        if (xTextDoc != null) {
            DesktopTools.closeDoc(xTextDoc);
        }
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a text document");
            xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)xTextDoc);
        XAccessible oObj = null;
        XAccessible secondItem = null;
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentContainerWindow((XMultiServiceFactory)tParam.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(log, xRoot, tParam.getBool("DebugIsActive"));
        XAccessibleContext statusbar = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)57);
        try {
            oObj = statusbar.getAccessibleChild(6);
            secondItem = statusbar.getAccessibleChild(1);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        log.println("ImplementationName: " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("EditOnly", "Can't change or select Text in StatusBarItem");
        tEnv.addObjRelation("XAccessibleText", secondItem);
        tEnv.addObjRelation("LimitedBounds", "yes");
        final XTextDocument doc = xTextDoc;
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                doc.getText().setString("AccessibleStatusBarItem");
            }
        });
        return tEnv;
    }
}

