/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.accessibility.XAccessibleValue;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleRadioButton
extends TestCase {
    private static XDesktop the_Desk;
    private static XTextDocument xTextDoc;
    private static XAccessibleAction accCloseButton;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        the_Desk = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)Param.getMSF()));
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        try {
            if (accCloseButton != null) {
                log.println("closing HyperlinkDialog");
                accCloseButton.doAccessibleAction(0);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
        }
        catch (DisposedException de) {
            log.println("Already disposed");
        }
        log.println("disposing xTextDoc");
        if (xTextDoc != null) {
            this.closeDoc();
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        log.println("creating a test environment");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a text document");
            xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        utils.shortWait(2000);
        XModel aModel1 = UnoRuntime.queryInterface(XModel.class, (Object)xTextDoc);
        XController secondController = aModel1.getCurrentController();
        XDispatchProvider aProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)secondController);
        XURLTransformer urlTransf = null;
        try {
            XInterface transf = (XInterface)((XMultiServiceFactory)tParam.getMSF()).createInstance("com.sun.star.util.URLTransformer");
            urlTransf = UnoRuntime.queryInterface(XURLTransformer.class, (Object)transf);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create URLTransformer", e);
        }
        XDispatch getting = null;
        log.println("opening HyperlinkDialog");
        URL[] url = new URL[]{new URL()};
        url[0].Complete = ".uno:HyperlinkDialog";
        urlTransf.parseStrict(url);
        getting = aProv.queryDispatch(url[0], "", 0);
        PropertyValue[] noArgs = new PropertyValue[]{};
        getting.dispatch(url[0], noArgs);
        utils.shortWait(2000);
        XInterface oObj = null;
        try {
            oObj = (XInterface)((XMultiServiceFactory)tParam.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)oObj);
        AccessibilityTools at = new AccessibilityTools();
        utils.shortWait(2000);
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)tk.getActiveTopWindow());
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        XAccessibleContext iconChoiceCtrl = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)65, "IconChoiceControl");
        XAccessibleSelection sel = UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)iconChoiceCtrl);
        try {
            sel.selectAccessibleChild(0);
        }
        catch (IndexOutOfBoundsException e) {
            log.println("Unexpected exception");
            e.printStackTrace(log);
        }
        AccessibilityTools.printAccessibleTree(log, xRoot, tParam.getBool("DebugIsActive"));
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)46, "Web");
        XAccessibleContext anotherButton = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)46, "FTP");
        XAccessibleContext closeButton = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)44, "Close");
        accCloseButton = UnoRuntime.queryInterface(XAccessibleAction.class, (Object)closeButton);
        log.println("ImplementationName: " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("EditOnly", "This method isn't supported in this component");
        tEnv.addObjRelation("LimitedBounds", "yes");
        final XAccessibleComponent acomp = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)oObj);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                acomp.grabFocus();
            }
        });
        tEnv.addObjRelation("XAccessibleText.Text", "Web");
        tEnv.addObjRelation("EditOnly", "Can't change or select Text in AccessibleRadioButton");
        XAccessibleValue anotherButtonValue = UnoRuntime.queryInterface(XAccessibleValue.class, (Object)anotherButton);
        tEnv.addObjRelation("XAccessibleValue.anotherFromGroup", anotherButtonValue);
        return tEnv;
    }

    protected void closeDoc() {
        DesktopTools.closeDoc(xTextDoc);
    }
}

