/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessiblePopupMenu
extends TestCase {
    private static XDesktop the_Desk;
    private static XTextDocument xTextDoc;
    private static Point point;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        the_Desk = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)Param.getMSF()));
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("release the popup menu");
        try {
            Robot rob = new Robot();
            int x = AccessiblePopupMenu.point.X;
            int y = AccessiblePopupMenu.point.Y;
            rob.mouseMove(x, y);
            rob.mousePress(16);
            rob.mouseRelease(16);
        }
        catch (AWTException e) {
            log.println("couldn't press mouse button");
        }
        log.println("disposing xTextDoc");
        if (xTextDoc != null) {
            this.closeDoc();
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        log.println("creating a test environment");
        if (xTextDoc != null) {
            this.closeDoc();
        }
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        XInterface toolkit = null;
        try {
            log.println("creating a text document");
            xTextDoc = SOF.createTextDoc(null);
            toolkit = (XInterface)((XMultiServiceFactory)tParam.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        this.shortWait(tParam);
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)xTextDoc);
        XAccessibleContext oObj = null;
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)tParam.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)40);
        XAccessibleComponent window = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)oObj);
        point = window.getLocationOnScreen();
        Rectangle rect = window.getBounds();
        try {
            Robot rob = new Robot();
            int x = AccessiblePopupMenu.point.X + rect.Width / 2;
            int y = AccessiblePopupMenu.point.Y + rect.Height / 2;
            rob.mouseMove(x, y);
            rob.mousePress(4);
            rob.mouseRelease(4);
        }
        catch (AWTException e) {
            log.println("couldn't press mouse button");
        }
        this.shortWait(tParam);
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)toolkit);
        try {
            xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)tk.getTopWindow(0));
            xRoot = AccessibilityTools.getAccessibleObject(xWindow);
            AccessibilityTools.printAccessibleTree(log, xRoot, tParam.getBool("DebugIsActive"));
        }
        catch (IndexOutOfBoundsException e) {
            log.println("Couldn't get Window");
        }
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)43);
        log.println("ImplementationName: " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("XAccessibleSelection.multiSelection", new Boolean(false));
        final XAccessibleSelection sel = UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)oObj);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                try {
                    sel.selectAccessibleChild(2);
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("Couldn't fire event");
                }
            }
        });
        return tEnv;
    }

    protected void closeDoc() {
        DesktopTools.closeDoc(xTextDoc);
    }

    private void shortWait(TestParameters tParam) {
        utils.shortWait(tParam.getInt("ShortWait"));
    }
}

