/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleMenuBar
extends TestCase {
    private static XTextDocument xTextDoc = null;
    private static XAccessibleAction action = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        try {
            oObj = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)oObj);
        this.shortWait();
        AccessibilityTools at = new AccessibilityTools();
        XTopWindow atw = tk.getActiveTopWindow();
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)atw);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)35);
        log.println("ImplementationName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        final XAccessibleComponent acomp = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)oObj);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                System.out.println("Grabbing focus ... ");
                acomp.grabFocus();
            }
        });
        tEnv.addObjRelation("XAccessibleSelection.OneAlwaysSelected", new Boolean(false));
        tEnv.addObjRelation("XAccessibleSelection.multiSelection", new Boolean(false));
        return tEnv;
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        try {
            SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
            xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            throw new StatusException("Can't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        DesktopTools.closeDoc(xTextDoc);
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }
}

