/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleMenu
extends TestCase {
    private static XTextDocument xTextDoc = null;
    private static XAccessibleAction action = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XMultiServiceFactory msf = (XMultiServiceFactory)Param.getMSF();
        try {
            SOfficeFactory SOF = SOfficeFactory.getFactory(msf);
            xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            throw new StatusException("Can't create document", e);
        }
        XInterface oObj = null;
        try {
            oObj = (XInterface)msf.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)oObj);
        this.shortWait();
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)tk.getActiveTopWindow());
        AccessibilityTools at = new AccessibilityTools();
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        XAccessibleContext menubar = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)35);
        XAccessible menu2 = null;
        try {
            oObj = menubar.getAccessibleChild(2);
            menu2 = menubar.getAccessibleChild(1);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        log.println("ImplementationName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        final XAccessibleAction act1 = UnoRuntime.queryInterface(XAccessibleAction.class, (Object)oObj);
        final XAccessibleAction act2 = UnoRuntime.queryInterface(XAccessibleAction.class, (Object)menu2);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                try {
                    act2.doAccessibleAction(0);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    act1.doAccessibleAction(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        XAccessibleText text = UnoRuntime.queryInterface(XAccessibleText.class, (Object)oObj);
        tEnv.addObjRelation("XAccessibleText.Text", text.getText());
        tEnv.addObjRelation("EditOnly", "Can't change or select Text in Menu");
        tEnv.addObjRelation("LimitedBounds", "yes");
        tEnv.addObjRelation("XAccessibleSelection.OneAlwaysSelected", new Boolean(false));
        tEnv.addObjRelation("XAccessibleSelection.multiSelection", new Boolean(false));
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        try {
            DesktopTools.closeDoc(xTextDoc);
        }
        catch (DisposedException e) {
            log.println("Object already disposed");
        }
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }
}

