/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XFixedText;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.utils;

public class AccessibleFixedText
extends TestCase {
    private static XTextDocument xTextDoc = null;
    private static XAccessibleAction action = null;
    private static XWindow xWinDlg = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
        XControlModel dlgModel = null;
        XControl txtControl = null;
        XControlModel txtModel = null;
        try {
            dlgModel = UnoRuntime.queryInterface(XControlModel.class, xMSF.createInstance("com.sun.star.awt.UnoControlDialogModel"));
            XControl dlgControl = UnoRuntime.queryInterface(XControl.class, xMSF.createInstance("com.sun.star.awt.UnoControlDialog"));
            dlgControl.setModel(dlgModel);
            txtModel = UnoRuntime.queryInterface(XControlModel.class, xMSF.createInstance("com.sun.star.awt.UnoControlFixedTextModel"));
            txtControl = UnoRuntime.queryInterface(XControl.class, xMSF.createInstance("com.sun.star.awt.UnoControlFixedText"));
            txtControl.setModel(txtModel);
            XFixedText xFT = UnoRuntime.queryInterface(XFixedText.class, (Object)txtControl);
            xFT.setText("FxedText");
            XControlContainer ctrlCont = UnoRuntime.queryInterface(XControlContainer.class, (Object)dlgControl);
            ctrlCont.addControl("Text", txtControl);
            xWinDlg = UnoRuntime.queryInterface(XWindow.class, (Object)dlgControl);
            xWinDlg.setVisible(true);
            xWinDlg.setPosSize(0, 0, 200, 100, (short)12);
        }
        catch (Exception e) {
            log.println("Error creating dialog :");
            e.printStackTrace(log);
        }
        try {
            oObj = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)oObj);
        this.shortWait();
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)tk.getActiveTopWindow());
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)30);
        log.println("ImplementationName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        final XWindow xWin = UnoRuntime.queryInterface(XWindow.class, (Object)txtControl);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                xWin.setEnable(false);
                xWin.setEnable(true);
            }
        });
        XAccessibleText text = UnoRuntime.queryInterface(XAccessibleText.class, (Object)oObj);
        tEnv.addObjRelation("XAccessibleText.Text", text.getText());
        tEnv.addObjRelation("EditOnly", "This method isn't supported in this component");
        tEnv.addObjRelation("LimitedBounds", "yes");
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("    Closing dialog ... ");
        xWinDlg.dispose();
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }
}

