/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleEdit
extends TestCase {
    private static XTextDocument xTextDoc = null;
    private static XAccessibleAction action = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        try {
            oObj = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)oObj);
        XModel aModel1 = UnoRuntime.queryInterface(XModel.class, (Object)xTextDoc);
        XController secondController = aModel1.getCurrentController();
        XDispatchProvider aProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)secondController);
        XURLTransformer urlTransf = null;
        try {
            XInterface transf = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.util.URLTransformer");
            urlTransf = UnoRuntime.queryInterface(XURLTransformer.class, (Object)transf);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create URLTransformer", e);
        }
        XDispatch getting = null;
        log.println("opening HyperlinkDialog");
        URL[] url = new URL[]{new URL()};
        url[0].Complete = ".uno:HyperlinkDialog";
        urlTransf.parseStrict(url);
        getting = aProv.queryDispatch(url[0], "", 0);
        PropertyValue[] noArgs = new PropertyValue[]{};
        getting.dispatch(url[0], noArgs);
        this.shortWait();
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)tk.getActiveTopWindow());
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)44, "Close");
        action = UnoRuntime.queryInterface(XAccessibleAction.class, (Object)oObj);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)60);
        log.println("ImplementationName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        final XAccessibleEditableText edText = UnoRuntime.queryInterface(XAccessibleEditableText.class, (Object)oObj);
        edText.setText("AccessibleEdit");
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                edText.setText("firing event ...");
                edText.setText("firing event ... 2");
                edText.setText("AccessibleEdit");
            }
        });
        XAccessibleText text = UnoRuntime.queryInterface(XAccessibleText.class, (Object)oObj);
        tEnv.addObjRelation("XAccessibleText.Text", text.getText());
        tEnv.addObjRelation("XAccessibleEditableText.hasAttr", Boolean.FALSE);
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("    Closing dialog ... ");
        try {
            action.doAccessibleAction(0);
        }
        catch (IndexOutOfBoundsException ioe) {
            log.println("Couldn't close dialog");
        }
        catch (DisposedException de) {
            log.println("Dialog already disposed");
        }
        DesktopTools.closeDoc(xTextDoc);
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        try {
            SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
            xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            throw new StatusException("Can't create document", e);
        }
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }
}

