/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleCheckBox
extends TestCase {
    private static XTextDocument xTextDoc = null;
    private static XAccessibleAction action = null;
    private static DiagThread psDiag = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XMultiServiceFactory msf = (XMultiServiceFactory)Param.getMSF();
        log.println("Creating text document");
        if (xTextDoc == null) {
            try {
                SOfficeFactory SOF = SOfficeFactory.getFactory(msf);
                xTextDoc = SOF.createTextDoc(null);
            }
            catch (Exception e) {
                throw new StatusException("Can't create document", e);
            }
        }
        utils.shortWait(Param.getInt("ShortWait"));
        XInterface oObj = null;
        log.println("getting toolkit");
        try {
            oObj = (XInterface)msf.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)oObj);
        utils.shortWait(Param.getInt("ShortWait"));
        log.println("Opening Dialog in second thread");
        psDiag = new DiagThread(xTextDoc, msf);
        psDiag.start();
        utils.shortWait(Param.getInt("ShortWait"));
        AccessibilityTools at = new AccessibilityTools();
        utils.shortWait(Param.getInt("ShortWait"));
        log.println("Getting the active TopWindow");
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)tk.getActiveTopWindow());
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)44, "Cancel");
        action = UnoRuntime.queryInterface(XAccessibleAction.class, (Object)oObj);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)4);
        log.println("ImplementationName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        final XAccessibleComponent acomp = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)oObj);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                System.out.println("Grabbing focus ... ");
                acomp.grabFocus();
            }
        });
        XAccessibleText text = UnoRuntime.queryInterface(XAccessibleText.class, (Object)oObj);
        tEnv.addObjRelation("XAccessibleText.Text", text.getText());
        tEnv.addObjRelation("EditOnly", "This method isn't supported in this component");
        tEnv.addObjRelation("LimitedBounds", "yes");
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        try {
            log.println("closing dialog");
            action.doAccessibleAction(0);
            log.println("interrupting corresponding Thread");
            psDiag.interrupt();
            log.println("closing the document");
            DesktopTools.closeDoc(xTextDoc);
            log.println("reinitialize the variable");
            xTextDoc = null;
        }
        catch (IndexOutOfBoundsException ioe) {
            log.println("Couldn't close dialog");
        }
        catch (DisposedException de) {
            log.println("Dialog already disposed");
        }
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
    }

    public class DiagThread
    extends Thread {
        public XTextDocument xTextDoc = null;
        public XMultiServiceFactory msf = null;

        public DiagThread(XTextDocument xTextDoc, XMultiServiceFactory msf) {
            this.xTextDoc = xTextDoc;
            this.msf = msf;
        }

        @Override
        public void run() {
            XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
            XController xController = aModel.getCurrentController();
            try {
                String aSlotID = ".uno:InsertTable";
                XDispatchProvider xDispProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xController);
                XURLTransformer xParser = UnoRuntime.queryInterface(XURLTransformer.class, this.msf.createInstance("com.sun.star.util.URLTransformer"));
                URL[] aParseURL = new URL[]{new URL()};
                aParseURL[0].Complete = aSlotID;
                xParser.parseStrict(aParseURL);
                URL aURL = aParseURL[0];
                XDispatch xDispatcher = xDispProv.queryDispatch(aURL, "", 0);
                if (xDispatcher != null) {
                    xDispatcher.dispatch(aURL, null);
                }
            }
            catch (Exception e) {
                AccessibleCheckBox.this.log.println("Couldn't open dialog");
            }
        }
    }
}

