/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleButton
extends TestCase {
    private static XTextDocument xTextDoc = null;
    private static XAccessibleAction action = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        XMultiServiceFactory msf = (XMultiServiceFactory)Param.getMSF();
        try {
            oObj = (XInterface)msf.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)oObj);
        utils.shortWait(Param.getInt("ShortWait"));
        DiagThread psDiag = new DiagThread(xTextDoc, msf);
        psDiag.start();
        utils.shortWait(Param.getInt("ShortWait"));
        AccessibilityTools at = new AccessibilityTools();
        utils.shortWait(Param.getInt("ShortWait"));
        XTopWindow atw = tk.getActiveTopWindow();
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)atw);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)44, "Cancel");
        log.println("ImplementationName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        action = UnoRuntime.queryInterface(XAccessibleAction.class, (Object)oObj);
        final XAccessibleComponent acomp = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)oObj);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                System.out.println("Grabbing focus ... ");
                acomp.grabFocus();
            }
        });
        XAccessibleText text = UnoRuntime.queryInterface(XAccessibleText.class, (Object)oObj);
        tEnv.addObjRelation("XAccessibleText.Text", text.getText());
        tEnv.addObjRelation("EditOnly", "This method isn't supported in this component");
        tEnv.addObjRelation("LimitedBounds", "yes");
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        try {
            action.doAccessibleAction(0);
        }
        catch (IndexOutOfBoundsException ioe) {
            log.println("Couldn't close dialog");
        }
        catch (DisposedException de) {
            log.println("Dialog already disposed");
        }
        DesktopTools.closeDoc(xTextDoc);
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        try {
            SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
            xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            throw new StatusException("Can't create document", e);
        }
    }

    public class DiagThread
    extends Thread {
        public XTextDocument xTextDoc = null;
        public XMultiServiceFactory msf = null;

        public DiagThread(XTextDocument xTextDoc, XMultiServiceFactory msf) {
            this.xTextDoc = xTextDoc;
            this.msf = msf;
        }

        @Override
        public void run() {
            XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
            XController xController = aModel.getCurrentController();
            try {
                String aSlotID = ".uno:Zoom";
                XDispatchProvider xDispProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xController);
                XURLTransformer xParser = UnoRuntime.queryInterface(XURLTransformer.class, this.msf.createInstance("com.sun.star.util.URLTransformer"));
                URL[] aParseURL = new URL[]{new URL()};
                aParseURL[0].Complete = aSlotID;
                xParser.parseStrict(aParseURL);
                URL aURL = aParseURL[0];
                XDispatch xDispatcher = xDispProv.queryDispatch(aURL, "", 0);
                if (xDispatcher != null) {
                    xDispatcher.dispatch(aURL, null);
                }
            }
            catch (Exception e) {
                AccessibleButton.this.log.println("Couldn't open dialog");
            }
        }
    }
}

