/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XFootnotesSupplier;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class XMLStylesImporter
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XInterface oObj = null;
        Object oInt = null;
        String impPrefix = "Prefix";
        log.println("creating a test environment");
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        try {
            oInt = xMSF.createInstance("com.sun.star.comp.Writer.XMLStylesImporter");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        oObj = (XInterface)oInt;
        log.println("creating a new environment for Paragraph object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("TargetDocument", this.xTextDoc);
        String[][] xml = new String[][]{{"start", "office:document-styles", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:style", "CDATA", "http://openoffice.org/2000/style", "xmlns:text", "CDATA", "http://openoffice.org/2000/text"}, {"start", "office:styles"}, {"start", "text:footnotes-configuration", "style:num-prefix", "CDATA", "Prefix"}, {"end", "text:footnotes-configuration"}, {"end", "office:styles"}, {"end", "office:document-styles"}};
        tEnv.addObjRelation("XDocumentHandler.XMLData", xml);
        XFootnotesSupplier supp = UnoRuntime.queryInterface(XFootnotesSupplier.class, (Object)this.xTextDoc);
        final XPropertySet set = supp.getFootnoteSettings();
        final PrintWriter logF = log;
        tEnv.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            @Override
            public boolean checkImport() {
                try {
                    String prefix = (String)set.getPropertyValue("Prefix");
                    logF.println("Prefix returned = '" + prefix + "'");
                    return "Prefix".equals(prefix);
                }
                catch (Exception e) {
                    logF.println("Exception occured while checking filter :");
                    e.printStackTrace(logF);
                    return false;
                }
            }
        });
        return tEnv;
    }
}

