/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XController;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.view.XViewSettingsSupplier;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class XMLSettingsImporter
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XInterface oObj = null;
        Object oInt = null;
        int impZoom = 50;
        log.println("creating a test environment");
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        try {
            oInt = xMSF.createInstance("com.sun.star.comp.Writer.XMLSettingsImporter");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        oObj = (XInterface)oInt;
        log.println("creating a new environment for Paragraph object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("TargetDocument", this.xTextDoc);
        String[][] xml = new String[][]{{"start", "office:document-settings", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:config", "CDATA", "http://openoffice.org/2001/config", "xmlns:xlink", "CDATA", "http://www.w3.org/1999/xlink"}, {"start", "office:settings"}, {"start", "config:config-item-set", "config:name", "CDATA", "view-settings"}, {"start", "config:config-item-map-indexed", "config:name", "CDATA", "Views"}, {"start", "config:config-item-map-entry"}, {"start", "config:config-item", "config:name", "CDATA", "ZoomFactor", "config:type", "CDATA", "short"}, {"chars", String.valueOf(50)}, {"end", "config:config-item"}, {"start", "config:config-item", "config:name", "CDATA", "ZoomType", "config:type", "CDATA", "short"}, {"chars", "0"}, {"end", "config:config-item"}, {"end", "config:config-item-map-entry"}, {"end", "config:config-item-map-indexed"}, {"end", "config:config-item-set"}, {"end", "office:settings"}, {"end", "office:document-settings"}};
        tEnv.addObjRelation("XDocumentHandler.XMLData", xml);
        final PrintWriter logF = log;
        XController xController = this.xTextDoc.getCurrentController();
        XViewSettingsSupplier xViewSetSup = UnoRuntime.queryInterface(XViewSettingsSupplier.class, (Object)xController);
        final XPropertySet xPropSet = xViewSetSup.getViewSettings();
        tEnv.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            @Override
            public boolean checkImport() {
                try {
                    Short gValue = (Short)xPropSet.getPropertyValue("ZoomValue");
                    logF.println("ZoomValue property value = " + gValue);
                    return 50 == gValue;
                }
                catch (Exception e) {
                    logF.println("Exception while checking import :");
                    e.printStackTrace(logF);
                    return false;
                }
            }
        });
        return tEnv;
    }
}

