/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XExporter;
import com.sun.star.frame.XController;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Any;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.view.XViewSettingsSupplier;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.XMLTools;

public class XMLSettingsExporter
extends TestCase {
    XTextDocument xTextDoc;
    SettingsFilterChecker Filter;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        int ZOOM = 50;
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        XInterface oObj = null;
        this.Filter = new SettingsFilterChecker(log);
        Any arg = new Any(new Type(XDocumentHandler.class), (Object)this.Filter);
        try {
            oObj = (XInterface)xMSF.createInstanceWithArguments("com.sun.star.comp.Writer.XMLSettingsExporter", new Object[]{arg});
            XExporter xEx = UnoRuntime.queryInterface(XExporter.class, (Object)oObj);
            xEx.setSourceDocument(this.xTextDoc);
            XController xController = this.xTextDoc.getCurrentController();
            XViewSettingsSupplier xViewSetSup = UnoRuntime.queryInterface(XViewSettingsSupplier.class, (Object)xController);
            XPropertySet xPropSet = xViewSetSup.getViewSettings();
            xPropSet.setPropertyValue("ZoomValue", new Short(50));
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        this.Filter.addTag(new XMLTools.Tag("office:document-settings"));
        this.Filter.addTagEnclosed(new XMLTools.Tag("office:settings"), new XMLTools.Tag("office:document-settings"));
        this.Filter.addCharactersEnclosed(String.valueOf(50), new XMLTools.Tag("config:config-item", "config:name", "ZoomFactor"));
        log.println("creating a new environment");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"swriter: StarOffice XML (Writer)"}));
        tEnv.addObjRelation("SourceDocument", this.xTextDoc);
        tEnv.addObjRelation("XFilter.Checker", this.Filter);
        return tEnv;
    }

    protected class SettingsFilterChecker
    extends XMLTools.XMLChecker
    implements _XFilter.FilterChecker {
        public SettingsFilterChecker(PrintWriter log) {
            super(log, false);
        }

        @Override
        public boolean checkFilter() {
            return this.check();
        }
    }
}

