/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class XMLMetaImporter
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XInterface oObj = null;
        Object oInt = null;
        String impTitle = "XMLMetaImporter test.";
        log.println("creating a test environment");
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        try {
            oInt = xMSF.createInstance("com.sun.star.comp.Writer.XMLMetaImporter");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        oObj = (XInterface)oInt;
        log.println("creating a new environment for Paragraph object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("TargetDocument", this.xTextDoc);
        String[][] xml = new String[][]{{"start", "office:document-meta", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:dc", "CDATA", "http://purl.org/dc/elements/1.1/"}, {"start", "office:meta"}, {"start", "dc:title"}, {"chars", "XMLMetaImporter test."}, {"end", "dc:title"}, {"end", "office:meta"}, {"end", "office:document-meta"}};
        tEnv.addObjRelation("XDocumentHandler.XMLData", xml);
        XDocumentInfoSupplier infoSup = UnoRuntime.queryInterface(XDocumentInfoSupplier.class, (Object)this.xTextDoc);
        final XPropertySet docInfo = UnoRuntime.queryInterface(XPropertySet.class, (Object)infoSup.getDocumentInfo());
        final PrintWriter logF = log;
        tEnv.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            @Override
            public boolean checkImport() {
                try {
                    String title = (String)docInfo.getPropertyValue("Title");
                    logF.println("Title returned = '" + title + "'");
                    return "XMLMetaImporter test.".equals(title);
                }
                catch (Exception e) {
                    logF.println("Exception occured while checking filter :");
                    e.printStackTrace(logF);
                    return false;
                }
            }
        });
        return tEnv;
    }
}

