/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.document.XImporter;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class XMLImporter
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        XInterface oObj = null;
        try {
            oObj = (XInterface)xMSF.createInstance("com.sun.star.comp.Writer.XMLImporter");
            XImporter xIm = UnoRuntime.queryInterface(XImporter.class, (Object)oObj);
            xIm.setTargetDocument(this.xTextDoc);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        log.println("creating a new environment");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        String impText = "XMLImporter test.";
        String[][] xml = new String[][]{{"start", "office:document", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "office:class", "CDATA", "text", "xmlns:text", "CDATA", "http://openoffice.org/2000/text"}, {"start", "office:body"}, {"start", "text:p"}, {"chars", "XMLImporter test."}, {"end", "text:p"}, {"end", "office:body"}, {"end", "office:document"}};
        tEnv.addObjRelation("XDocumentHandler.XMLData", xml);
        tEnv.addObjRelation("TargetDocument", this.xTextDoc);
        log.println("Implementation Name: " + utils.getImplName(oObj));
        final XTextDocument textDoc = UnoRuntime.queryInterface(XTextDocument.class, (Object)this.xTextDoc);
        final PrintWriter fLog = log;
        tEnv.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            @Override
            public boolean checkImport() {
                String docText = textDoc.getText().getString();
                fLog.println("Document text returned = '" + docText + "'");
                return "XMLImporter test.".equals(docText);
            }
        });
        return tEnv;
    }
}

