/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.document.XExporter;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Any;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.XMLTools;
import util.utils;

public class XMLExporter
extends TestCase {
    XTextDocument xTextDoc;
    FilterChecker Filter;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        String TEST_STR = "XMLExporter";
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        XInterface oObj = null;
        this.Filter = new FilterChecker(log);
        Any arg = new Any(new Type(XDocumentHandler.class), (Object)this.Filter);
        try {
            oObj = (XInterface)xMSF.createInstanceWithArguments("com.sun.star.comp.Writer.XMLExporter", new Object[]{arg});
            XExporter xEx = UnoRuntime.queryInterface(XExporter.class, (Object)oObj);
            xEx.setSourceDocument(this.xTextDoc);
            XText aText = this.xTextDoc.getText();
            XTextCursor curs = aText.createTextCursor();
            aText.insertString(curs, "XMLExporter", false);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        this.Filter.addTag("office:document");
        this.Filter.addTagEnclosed("office:meta", "office:document");
        this.Filter.addTagEnclosed("office:settings", "office:document");
        this.Filter.addTagEnclosed("office:script", "office:document");
        this.Filter.addTagEnclosed("office:styles", "office:document");
        this.Filter.addTagEnclosed("office:body", "office:document");
        this.Filter.addCharactersEnclosed("XMLExporter", "text:p");
        log.println("creating a new environment");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"swriter: StarOffice XML (Writer)"}));
        tEnv.addObjRelation("SourceDocument", this.xTextDoc);
        tEnv.addObjRelation("XFilter.Checker", this.Filter);
        log.println("Implementation Name: " + utils.getImplName(oObj));
        return tEnv;
    }

    protected class FilterChecker
    extends XMLTools.XMLTagsChecker
    implements _XFilter.FilterChecker {
        public FilterChecker(PrintWriter log) {
            super(log);
        }

        @Override
        public boolean checkFilter() {
            return this.checkTags();
        }
    }
}

