/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.document.XExporter;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Any;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.XMLTools;

public class XMLContentExporter
extends TestCase {
    XTextDocument xTextDoc;
    ContentFilterChecker Filter;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        String CONTENT = "XMLContentExporter";
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        XInterface oObj = null;
        this.Filter = new ContentFilterChecker(log);
        Any arg = new Any(new Type(XDocumentHandler.class), (Object)this.Filter);
        try {
            oObj = (XInterface)xMSF.createInstanceWithArguments("com.sun.star.comp.Writer.XMLContentExporter", new Object[]{arg});
            XExporter xEx = UnoRuntime.queryInterface(XExporter.class, (Object)oObj);
            xEx.setSourceDocument(this.xTextDoc);
            XText aText = this.xTextDoc.getText();
            XTextCursor curs = aText.createTextCursor();
            aText.insertString(curs, "XMLContentExporter", false);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        this.Filter.addTag("office:document-content");
        this.Filter.addTagEnclosed("office:body", "office:document-content");
        this.Filter.addTagEnclosed("office:script", "office:document-content");
        this.Filter.addTagEnclosed("office:body", "office:document-content");
        this.Filter.addCharactersEnclosed("XMLContentExporter", "text:p");
        log.println("creating a new environment");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"swriter: StarOffice XML (Writer)"}));
        tEnv.addObjRelation("SourceDocument", this.xTextDoc);
        tEnv.addObjRelation("XFilter.Checker", this.Filter);
        return tEnv;
    }

    protected class ContentFilterChecker
    extends XMLTools.XMLTagsChecker
    implements _XFilter.FilterChecker {
        public ContentFilterChecker(PrintWriter log) {
            super(log);
        }

        @Override
        public boolean checkFilter() {
            return this.checkTags();
        }
    }
}

