/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XControlShape;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.form.XForm;
import com.sun.star.frame.XController;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFrame;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XSearchDescriptor;
import com.sun.star.util.XSearchable;
import com.sun.star.view.XSelectionSupplier;
import java.io.PrintWriter;
import java.util.Comparator;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.SOfficeFactory;
import util.WriterTools;
import util.dbg;

public class SwXTextView
extends TestCase {
    XTextDocument xTextDoc;
    boolean debug = false;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
            this.debug = tParam.getBool("DebugIsActive");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        log.println("creating a test environment");
        XController xContr = this.xTextDoc.getCurrentController();
        TestEnvironment tEnv = new TestEnvironment(xContr);
        dbg.getSuppServices(xContr);
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        XTextFrame first = null;
        XTextFrame second = null;
        Object oFrame1 = null;
        Object oFrame2 = null;
        try {
            XText oText = this.xTextDoc.getText();
            XTextCursor oCursor = oText.createTextCursor();
            oFrame1 = SOF.createInstance(this.xTextDoc, "com.sun.star.text.TextFrame");
            first = UnoRuntime.queryInterface(XTextFrame.class, oFrame1);
            oText.insertTextContent(oCursor, first, false);
            first.getText().setString("Frame 1");
            oFrame2 = SOF.createInstance(this.xTextDoc, "com.sun.star.text.TextFrame");
            second = UnoRuntime.queryInterface(XTextFrame.class, oFrame2);
            oText.insertTextContent(oCursor, second, false);
            second.getText().setString("Frame 2");
            oText.insertString(oCursor, "SwXTextRanges...SwXTextRanges...SwXTextRanges", false);
            oText.insertControlCharacter(oCursor, (short)0, false);
            oText.insertString(oCursor, "bla...bla...", false);
        }
        catch (Exception Ex) {
            Ex.printStackTrace(log);
            throw new StatusException("Couldn't insert text table ", Ex);
        }
        XSearchable oSearch = UnoRuntime.queryInterface(XSearchable.class, (Object)this.xTextDoc);
        XSearchDescriptor xSDesc = oSearch.createSearchDescriptor();
        xSDesc.setSearchString("SwXTextRanges");
        XIndexAccess textRanges1 = oSearch.findAll(xSDesc);
        xSDesc.setSearchString("bla");
        XIndexAccess textRanges2 = oSearch.findAll(xSDesc);
        tEnv.addObjRelation("Selections", new Object[]{oFrame1, oFrame2, textRanges1, textRanges2});
        tEnv.addObjRelation("Comparer", new Comparator(){

            public int compare(Object o1, Object o2) {
                String implName2;
                XServiceInfo serv1 = UnoRuntime.queryInterface(XServiceInfo.class, o1);
                XServiceInfo serv2 = UnoRuntime.queryInterface(XServiceInfo.class, o2);
                String implName1 = serv1.getImplementationName();
                if (!implName1.equals(implName2 = serv2.getImplementationName())) {
                    return -1;
                }
                XIndexAccess indAc1 = UnoRuntime.queryInterface(XIndexAccess.class, o1);
                XIndexAccess indAc2 = UnoRuntime.queryInterface(XIndexAccess.class, o2);
                if (indAc1 != null && indAc2 != null) {
                    int c2;
                    int c1 = indAc1.getCount();
                    return c1 == (c2 = indAc2.getCount()) ? 0 : 1;
                }
                XText text1 = UnoRuntime.queryInterface(XText.class, o1);
                XText text2 = UnoRuntime.queryInterface(XText.class, o2);
                if (text1 != null && text2 != null) {
                    return text1.getString().equals(text2.getString()) ? 0 : 1;
                }
                return -1;
            }

            @Override
            public boolean equals(Object obj) {
                return this.compare(this, obj) == 0;
            }
        });
        XSelectionSupplier xsel = UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)xContr);
        try {
            xsel.select(second);
        }
        catch (Exception e) {
            log.println("Couldn't select");
            throw new StatusException("Couldn't select", e);
        }
        tEnv.addObjRelation("DOCUMENT", this.xTextDoc);
        XForm myForm = null;
        String kindOfControl = "CommandButton";
        XControlShape aShape = null;
        try {
            log.println("adding contol shape '" + kindOfControl + "'");
            aShape = FormTools.createControlShape(this.xTextDoc, 3000, 4500, 15000, 10000, kindOfControl);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create following control shape : '" + kindOfControl + "': ", e);
        }
        log.println("adding relation for com.sun.star.view.XFormLayerAccess: XForm");
        WriterTools.getDrawPage(this.xTextDoc).add(aShape);
        try {
            XNameContainer xForms;
            XDrawPage xDP = WriterTools.getDrawPage(this.xTextDoc);
            if (xDP == null) {
                log.println("ERROR: could not get DrawPage");
            }
            if ((xForms = FormTools.getForms(xDP)) == null) {
                log.println("ERROR: could not get Forms");
            }
            log.println("the draw page contains folowing elemtens:");
            String[] elements = FormTools.getForms(WriterTools.getDrawPage(this.xTextDoc)).getElementNames();
            for (int i = 0; i < elements.length; ++i) {
                log.println("Element[" + i + "] :" + elements[i]);
            }
            myForm = (XForm)AnyConverter.toObject((Type)new Type(XForm.class), (Object)xForms.getByName("Standard"));
            if (myForm == null) {
                log.println("ERROR: could not get 'Standard' from drawpage!");
                if (this.debug) {
                    log.println("the draw page contains folowing elemtens:");
                }
            } else {
                tEnv.addObjRelation("XFormLayerAccess.XForm", myForm);
            }
        }
        catch (WrappedTargetException ex) {
            log.println("ERROR: could not add ObjectRelation 'XFormLayerAccess.XForm': " + ex.toString());
        }
        catch (IllegalArgumentException ex) {
            log.println("ERROR: could not add ObjectRelation 'XFormLayerAccess.XForm': " + ex.toString());
        }
        catch (NoSuchElementException ex) {
            log.println("ERROR: could not add ObjectRelation 'XFormLayerAccess.XForm': " + ex.toString());
        }
        return tEnv;
    }
}

