/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXTextTables
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XNameAccess oObj = null;
        int nRow = 4;
        int nCol = 5;
        log.println("creating a test environment");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        TestEnvironment tEnv = null;
        XTextTable oTable = null;
        try {
            oTable = SOfficeFactory.createTextTable(this.xTextDoc);
            SOfficeFactory.insertTextContent(this.xTextDoc, oTable);
        }
        catch (Exception uE) {
            uE.printStackTrace(log);
            throw new StatusException("Couldn't create TextTable : " + uE.getMessage(), uE);
        }
        XTextTable oTable2 = null;
        try {
            oTable2 = SOfficeFactory.createTextTable(this.xTextDoc);
            SOfficeFactory.insertTextContent(this.xTextDoc, oTable2);
        }
        catch (Exception uE) {
            uE.printStackTrace(log);
            throw new StatusException("Couldn't create TextTable two: " + uE.getMessage(), uE);
        }
        XMultiServiceFactory msf = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
        XTextTablesSupplier oTTSupp = UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)msf);
        oObj = oTTSupp.getTextTables();
        if (oTable != null) {
            log.println("Creating instance...");
            tEnv = new TestEnvironment(oObj);
        }
        log.println("adding TextDocument as mod relation to environment");
        tEnv.addObjRelation("TEXTDOC", this.xTextDoc);
        tEnv.addObjRelation("ROW", new Integer(nRow));
        tEnv.addObjRelation("COL", new Integer(nCol));
        try {
            tEnv.addObjRelation("INST", SOfficeFactory.createTextTable(this.xTextDoc));
        }
        catch (Exception uE) {
            uE.printStackTrace(log);
            throw new StatusException("Couldn't create TextTable : " + uE.getMessage(), uE);
        }
        return tEnv;
    }
}

