/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTableCursor;
import com.sun.star.uno.Exception;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXTextTableCursor
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XTextTableCursor oObj = null;
        log.println("creating a test environment");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        XTextTable oTable = null;
        try {
            oTable = SOfficeFactory.createTextTable(this.xTextDoc);
            SOfficeFactory.insertTextContent(this.xTextDoc, oTable);
        }
        catch (Exception uE) {
            uE.printStackTrace(log);
            throw new StatusException("Couldn't create TextTable : " + uE.getMessage(), uE);
        }
        oObj = oTable.createCursorByCellName("A1");
        log.println("creating a new environment for TextTableCursor object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("adding TextDocument as mod relation to environment");
        tEnv.addObjRelation("TEXTDOC", this.xTextDoc);
        tEnv.addObjRelation("STYLENAME1", "Table");
        tEnv.addObjRelation("STYLENAME2", "Text");
        return tEnv;
    }
}

