/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.table.XCell;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.UnoRuntime;
import ifc.util._XSortable;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.ValueComparer;

public class SwXTextTable
extends TestCase {
    SOfficeFactory SOF;
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        this.SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = this.SOF.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XTextTable oObj = null;
        TestEnvironment tEnv = null;
        XTextTable instance = null;
        try {
            oObj = SOfficeFactory.createTextTable(this.xTextDoc);
            instance = SOfficeFactory.createTextTable(this.xTextDoc);
        }
        catch (com.sun.star.uno.Exception uE) {
            uE.printStackTrace(log);
            throw new StatusException("Couldn't create testobj : " + uE.getMessage(), uE);
        }
        int nRow = 6;
        int nCol = 2;
        oObj.initialize(nRow, nCol);
        log.println("Creating instance...");
        tEnv = new TestEnvironment(oObj);
        if (SOfficeFactory.getTableCollection(this.xTextDoc).getCount() == 0) {
            try {
                SOfficeFactory.insertTextContent(this.xTextDoc, oObj);
            }
            catch (com.sun.star.uno.Exception uE) {
                uE.printStackTrace(log);
                throw new StatusException("Couldn't create TextTable : " + uE.getMessage(), uE);
            }
        }
        XPropertySet props = UnoRuntime.queryInterface(XPropertySet.class, (Object)oObj);
        try {
            props.setPropertyValue("ChartRowAsLabel", new Boolean(true));
            props.setPropertyValue("ChartColumnAsLabel", new Boolean(true));
        }
        catch (Exception e) {
            e.printStackTrace(log);
        }
        tEnv.addObjRelation("NROW", new Integer(nRow));
        tEnv.addObjRelation("NCOL", new Integer(nCol));
        Object[][] newData = new Object[6][];
        Object[] line = new Object[]{new Double(1.5), new Double(2.5)};
        newData[0] = line;
        newData[1] = line;
        newData[2] = line;
        newData[3] = line;
        newData[4] = line;
        newData[5] = line;
        tEnv.addObjRelation("NewData", newData);
        final PrintWriter finalLog = log;
        final XTextTable oTable = oObj;
        tEnv.addObjRelation("SORTCHECKER", new _XSortable.XSortChecker(){
            PrintWriter out;
            {
                this.out = finalLog;
            }

            @Override
            public void setPrintWriter(PrintWriter log) {
                this.out = log;
            }

            @Override
            public void prepareToSort() {
                oTable.getCellByName("A1").setValue(4.0);
                XTextRange textRange = UnoRuntime.queryInterface(XTextRange.class, (Object)oTable.getCellByName("A2"));
                textRange.setString("b");
                oTable.getCellByName("A3").setValue(3.0);
                textRange = UnoRuntime.queryInterface(XTextRange.class, (Object)oTable.getCellByName("A4"));
                textRange.setString("a");
                oTable.getCellByName("A5").setValue(23.0);
                textRange = UnoRuntime.queryInterface(XTextRange.class, (Object)oTable.getCellByName("A6"));
                textRange.setString("ab");
            }

            @Override
            public boolean checkSort(boolean isSortNumbering, boolean isSortAscending) {
                this.out.println("Sort checking...");
                boolean res = false;
                String[] value = new String[6];
                for (int i = 0; i < 6; ++i) {
                    XCell cell = oTable.getCellByName("A" + (i + 1));
                    XTextRange textRange = UnoRuntime.queryInterface(XTextRange.class, (Object)cell);
                    value[i] = textRange.getString();
                }
                if (isSortNumbering) {
                    String[] vals;
                    if (isSortAscending) {
                        String[] rightVal = new String[]{"3", "4", "23"};
                        vals = new String[]{value[3], value[4], value[5]};
                        res = ValueComparer.equalValue(vals, rightVal);
                        if (!res) {
                            this.out.println("Expected: 3, 4, 23");
                            this.out.println("Getting: " + value[3] + ", " + value[4] + ", " + value[5]);
                        }
                    } else {
                        String[] rightVal = new String[]{"23", "4", "3"};
                        vals = new String[]{value[0], value[1], value[2]};
                        res = ValueComparer.equalValue(vals, rightVal);
                        if (!res) {
                            this.out.println("Expected: 23, 4, 3");
                            this.out.println("Getting: " + value[1] + ", " + value[2] + ", " + value[3]);
                        }
                    }
                } else if (isSortAscending) {
                    String[] rightVal = new String[]{"23", "3", "4", "a", "ab", "b"};
                    res = ValueComparer.equalValue(value, rightVal);
                    if (!res) {
                        this.out.println("Expected: 23, 3, 4, a, ab, b");
                        this.out.println("Getting: " + value[0] + ", " + value[1] + ", " + value[2] + ", " + value[3] + ", " + value[4] + ", " + value[5]);
                    }
                } else {
                    String[] rightVal = new String[]{"b", "ab", "a", "4", "3", "23"};
                    res = ValueComparer.equalValue(value, rightVal);
                    if (!res) {
                        this.out.println("Expected: b, ab, a, 4, 3, 23");
                        this.out.println("Getting: " + value[0] + ", " + value[1] + ", " + value[2] + ", " + value[3] + ", " + value[4] + ", " + value[5]);
                    }
                }
                if (res) {
                    this.out.println("Sorted correctly");
                } else {
                    this.out.println("Sorted uncorrectly");
                }
                return res;
            }
        });
        tEnv.addObjRelation("CONTENT", UnoRuntime.queryInterface(XTextContent.class, (Object)instance));
        tEnv.addObjRelation("RANGE", this.xTextDoc.getText().createTextCursor());
        return tEnv;
    }
}

