/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextSectionsSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXTextSections
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XTextContent oTSC;
        XNameAccess oObj = null;
        XInterface oTS = null;
        XNameAccess oTSSuppName = null;
        XText oText = null;
        log.println("creating a test environment");
        oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        log.println("inserting TextSections");
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
        try {
            oTS = (XInterface)oDocMSF.createInstance("com.sun.star.text.TextSection");
            oTSC = UnoRuntime.queryInterface(XTextContent.class, (Object)oTS);
            oText.insertTextContent(oCursor, oTSC, false);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        try {
            oTS = (XInterface)oDocMSF.createInstance("com.sun.star.text.TextSection");
            oTSC = UnoRuntime.queryInterface(XTextContent.class, (Object)oTS);
            oText.insertTextContent(oCursor, oTSC, false);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        log.println("try to get a TextSection with the XTextSectionSupplier()");
        try {
            XTextSectionsSupplier oTSSupp = UnoRuntime.queryInterface(XTextSectionsSupplier.class, (Object)this.xTextDoc);
            oTSSuppName = oTSSupp.getTextSections();
        }
        catch (Exception e) {
            System.out.println("Couldn't get Textsection " + e);
        }
        oObj = oTSSuppName;
        log.println("creating a new environment for TextSections object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("adding TextDocument as mod relation to environment");
        tEnv.addObjRelation("TEXTDOC", this.xTextDoc);
        return tEnv;
    }
}

