/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextColumns;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextSection;
import com.sun.star.text.XTextSectionsSupplier;
import com.sun.star.text.XWordCursor;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.InstCreator;
import util.SOfficeFactory;
import util.TableDsc;

public class SwXTextSection
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XTextSection oObj = null;
        XInterface oTS = null;
        XTextSection xTS = null;
        XText oText = null;
        XTextColumns TC = null;
        Object instance = null;
        log.println("creating a test environment");
        oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
        try {
            XTextSectionsSupplier oTSSupp = UnoRuntime.queryInterface(XTextSectionsSupplier.class, (Object)this.xTextDoc);
            XNameAccess oTSSuppName = oTSSupp.getTextSections();
            if (oTSSuppName.hasByName("SwXTextSection")) {
                XTextSection old = (XTextSection)AnyConverter.toObject((Type)new Type(XTextSection.class), (Object)oTSSuppName.getByName("SwXTextSection"));
                XComponent oldC = UnoRuntime.queryInterface(XComponent.class, (Object)old);
                oldC.dispose();
                oText.setString("");
            }
            oTS = (XInterface)oDocMSF.createInstance("com.sun.star.text.TextSection");
            instance = oDocMSF.createInstance("com.sun.star.text.TextSection");
            XTextContent oTSC = UnoRuntime.queryInterface(XTextContent.class, (Object)oTS);
            oText.insertTextContent(oCursor, oTSC, false);
            XWordCursor oWordC = UnoRuntime.queryInterface(XWordCursor.class, (Object)oCursor);
            oCursor.setString("End of TextSection");
            oCursor.gotoStart(false);
            oCursor.setString("Start of TextSection ");
            oWordC.gotoEndOfWord(false);
            XInterface oTS2 = (XInterface)oDocMSF.createInstance("com.sun.star.text.TextSection");
            oTSC = UnoRuntime.queryInterface(XTextContent.class, (Object)oTS2);
            oText.insertTextContent(oCursor, oTSC, false);
            XIndexAccess oTSSuppIndex = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oTSSuppName);
            log.println("getting a TextSection with the XTextSectionSupplier()");
            xTS = (XTextSection)AnyConverter.toObject((Type)new Type(XTextSection.class), (Object)oTSSuppIndex.getByIndex(0));
            XNamed xTSName = UnoRuntime.queryInterface(XNamed.class, (Object)xTS);
            xTSName.setName("SwXTextSection");
        }
        catch (Exception e) {
            System.out.println("Couldn't get Textsection " + e);
        }
        oObj = xTS;
        log.println("creating a new environment for TextSection object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("adding InstDescriptor object");
        TableDsc tDsc = new TableDsc(6, 4);
        log.println("adding InstCreator object");
        tEnv.addObjRelation("XTEXTINFO", new InstCreator(this.xTextDoc, tDsc));
        tEnv.addObjRelation("TRO", new Boolean(true));
        try {
            TC = UnoRuntime.queryInterface(XTextColumns.class, oDocMSF.createInstance("com.sun.star.text.TextColumns"));
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create instance of service TextColumns", e);
        }
        tEnv.addObjRelation("TC", TC);
        tEnv.addObjRelation("CONTENT", UnoRuntime.queryInterface(XTextContent.class, instance));
        tEnv.addObjRelation("RANGE", this.xTextDoc.getText().createTextCursor());
        return tEnv;
    }
}

