/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XSearchDescriptor;
import com.sun.star.util.XSearchable;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXTextSearch
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XSearchDescriptor oObj = null;
        log.println("creating a test environment");
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        for (int j = 0; j < 5; ++j) {
            try {
                oText.insertString(oCursor, "SwXTextSearch...SwXTextSearch...SwXTextSearch", false);
                oText.insertControlCharacter(oCursor, (short)0, false);
                continue;
            }
            catch (Exception e) {
                log.println("EXCEPTION: " + e);
            }
        }
        XSearchable oSearch = UnoRuntime.queryInterface(XSearchable.class, (Object)this.xTextDoc);
        XSearchDescriptor xSDesc = oSearch.createSearchDescriptor();
        xSDesc.setSearchString("SwXTextSearch");
        oObj = xSDesc;
        log.println("creating a new environment for TextSearch object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("adding TextDocument as mod relation to environment");
        tEnv.addObjRelation("TEXTDOC", this.xTextDoc);
        return tEnv;
    }
}

