/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXTextPortionEnumeration
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XInterface param = null;
        log.println("creating a test environment");
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        log.println("inserting Strings");
        log.println("inserting ControlCharacter");
        try {
            for (int i = 0; i < 5; ++i) {
                oText.insertString(oCursor, "Paragraph Number: " + i, false);
                oText.insertControlCharacter(oCursor, (short)1, false);
                oText.insertString(oCursor, "The quick brown fox jumps over the lazy Dog: SwXParagraph\n", false);
                oText.insertControlCharacter(oCursor, (short)1, false);
                oText.insertString(oCursor, "THE QUICK BROWN FOX JUMPS OVER THE LAZY DOG: SwXParagraph", false);
                oText.insertControlCharacter(oCursor, (short)0, false);
            }
        }
        catch (Exception e) {
            log.println("Couldn't insert Text");
            e.printStackTrace();
            throw new StatusException("Couldn't insert Text", e);
        }
        XEnumerationAccess oEnumA = UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)oText);
        XEnumeration oEnum = oEnumA.createEnumeration();
        int n = 0;
        while (oEnum.hasMoreElements()) {
            try {
                param = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)oEnum.nextElement());
            }
            catch (Exception e) {
                log.println("Couldn't get Paragraph");
                e.printStackTrace();
                throw new StatusException("Couldn't get Paragraph", e);
            }
            ++n;
        }
        XEnumerationAccess oEnumP = UnoRuntime.queryInterface(XEnumerationAccess.class, param);
        XEnumeration oEnum2 = oEnumP.createEnumeration();
        log.println("creating a new environment for TextPortionEnumeration object");
        TestEnvironment tEnv = new TestEnvironment(oEnum2);
        log.println("adding ObjRelation ENUM for XEnumeration");
        tEnv.addObjRelation("ENUM", oEnumP);
        return tEnv;
    }
}

