/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextGraphicObjectsSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class SwXTextGraphicObjects
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdoc");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XInterface oObj = null;
        Object oGObject = null;
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            oGObject = SOF.createInstance(this.xTextDoc, "com.sun.star.text.GraphicObject");
        }
        catch (Exception ex) {
            log.println("Couldn't create instance");
            ex.printStackTrace(log);
            throw new StatusException("Couldn't create instance", ex);
        }
        oObj = (XInterface)oGObject;
        XText the_text = this.xTextDoc.getText();
        XTextCursor the_cursor = the_text.createTextCursor();
        XTextContent the_content = UnoRuntime.queryInterface(XTextContent.class, (Object)oObj);
        log.println("inserting graphic");
        try {
            the_text.insertTextContent(the_cursor, the_content, true);
        }
        catch (Exception e) {
            System.out.println("Couldn't insert Content");
            e.printStackTrace();
            throw new StatusException("Couldn't insert Content", e);
        }
        log.println("adding graphic");
        XPropertySet oProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)oObj);
        try {
            String wat = utils.getFullTestURL("space-metal.jpg");
            oProps.setPropertyValue("GraphicURL", wat);
            oProps.setPropertyValue("HoriOrientPosition", new Integer(5500));
            oProps.setPropertyValue("VertOrientPosition", new Integer(4200));
            oProps.setPropertyValue("Width", new Integer(4400));
            oProps.setPropertyValue("Height", new Integer(4000));
        }
        catch (Exception e) {
            System.out.println("Couldn't set property 'GraphicURL'");
            e.printStackTrace();
            throw new StatusException("Couldn't set property 'GraphicURL'", e);
        }
        XTextGraphicObjectsSupplier xTGS = UnoRuntime.queryInterface(XTextGraphicObjectsSupplier.class, (Object)this.xTextDoc);
        oObj = xTGS.getGraphicObjects();
        TestEnvironment tEnv = new TestEnvironment(oObj);
        return tEnv;
    }
}

