/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFrame;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class SwXTextGraphicObject
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdoc");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xDrawDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XInterface oObj = null;
        Object oGObject = null;
        XTextFrame xTextFrame = null;
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        Object instance = null;
        try {
            oGObject = SOF.createInstance(this.xTextDoc, "com.sun.star.text.GraphicObject");
            instance = SOF.createInstance(this.xTextDoc, "com.sun.star.text.GraphicObject");
            xTextFrame = SOfficeFactory.createTextFrame(this.xTextDoc, 500, 500);
        }
        catch (Exception ex) {
            log.println("Couldn't create instance");
            ex.printStackTrace(log);
            throw new StatusException("Couldn't create instance", ex);
        }
        oObj = (XInterface)oGObject;
        XText the_text = this.xTextDoc.getText();
        XTextCursor the_cursor = the_text.createTextCursor();
        XTextContent the_content = UnoRuntime.queryInterface(XTextContent.class, (Object)oObj);
        log.println("inserting Frame");
        try {
            XTextContent Framecontent = UnoRuntime.queryInterface(XTextContent.class, (Object)xTextFrame);
            the_text.insertTextContent(the_cursor, Framecontent, true);
        }
        catch (Exception e) {
            System.out.println("Couldn't insert text frame");
            e.printStackTrace();
            throw new StatusException("Couldn't insert text frame", e);
        }
        log.println("inserting graphic");
        try {
            the_text.insertTextContent(the_cursor, the_content, true);
        }
        catch (Exception e) {
            System.out.println("Couldn't insert Content");
            e.printStackTrace();
            throw new StatusException("Couldn't insert Content", e);
        }
        log.println("adding graphic");
        XPropertySet oProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)oObj);
        try {
            String wat = utils.getFullTestURL("space-metal.jpg");
            oProps.setPropertyValue("AnchorType", TextContentAnchorType.AT_PARAGRAPH);
            oProps.setPropertyValue("GraphicURL", wat);
            oProps.setPropertyValue("HoriOrientPosition", new Integer(5500));
            oProps.setPropertyValue("VertOrientPosition", new Integer(4200));
            oProps.setPropertyValue("Width", new Integer(4400));
            oProps.setPropertyValue("Height", new Integer(4000));
        }
        catch (Exception e) {
            System.out.println("Couldn't set property 'GraphicURL'");
            e.printStackTrace();
            throw new StatusException("Couldn't set property 'GraphicURL'", e);
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("adding ObjRelation for XShape (get/setPosition won't work there)");
        tEnv.addObjRelation("NoPos", "SwXTextGraphicObject");
        tEnv.addObjRelation("NoSetSize", "SwXTextGraphicObject");
        Object ImgMap = null;
        try {
            XMultiServiceFactory xDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
            ImgMap = xDocMSF.createInstance("com.sun.star.image.ImageMapRectangleObject");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        tEnv.addObjRelation("IMGMAP", ImgMap);
        tEnv.addObjRelation("CONTENT", UnoRuntime.queryInterface(XTextContent.class, instance));
        tEnv.addObjRelation("RANGE", this.xTextDoc.getText().createTextCursor());
        tEnv.addObjRelation("TextFrame", xTextFrame);
        return tEnv;
    }
}

