/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFrame;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.InstCreator;
import util.ParagraphDsc;
import util.SOfficeFactory;
import util.TableDsc;

public class SwXTextFrameText
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XText oObj = null;
        XTextFrame oFrame1 = null;
        XPropertySet oPropSet = null;
        XText oText = null;
        XTextCursor oCursor = null;
        log.println("creating a test environment");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            oFrame1 = SOfficeFactory.createTextFrame(this.xTextDoc, 500, 500);
            oPropSet = UnoRuntime.queryInterface(XPropertySet.class, (Object)oFrame1);
            oPropSet.setPropertyValue("AnchorType", new Integer(2));
            oText = this.xTextDoc.getText();
            oCursor = oText.createTextCursor();
            log.println("inserting Frame1");
            oText.insertTextContent(oCursor, oFrame1, false);
        }
        catch (Exception Ex) {
            Ex.printStackTrace(log);
            throw new StatusException("Couldn't insert TextFrame ", Ex);
        }
        XText oFText = UnoRuntime.queryInterface(XText.class, (Object)oFrame1);
        XTextCursor oFCursor = oFText.createTextCursor();
        oFText.insertString(oFCursor, "SwXTextFrameText", false);
        oObj = oFText.getText();
        log.println("creating a new environment for TextFrameText object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("adding TextDocument as mod relation to environment");
        tEnv.addObjRelation("TEXT", oObj);
        log.println("adding InstDescriptor object");
        TableDsc tDsc = new TableDsc(6, 4);
        log.println("adding InstCreator object");
        tEnv.addObjRelation("XTEXTINFO", new InstCreator(this.xTextDoc, tDsc));
        log.println("    adding Paragraph");
        ParagraphDsc pDsc = new ParagraphDsc();
        tEnv.addObjRelation("PARA", new InstCreator(this.xTextDoc, pDsc));
        return tEnv;
    }
}

