/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFrame;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXTextFrame
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XTextFrame oObj = null;
        XTextFrame oFrame1 = null;
        XTextFrame oFrame2 = null;
        XPropertySet oPropSet = null;
        XText oText = null;
        XTextCursor oCursor = null;
        log.println("creating a test environment");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        log.println("creating Frames");
        Object instance = null;
        try {
            oFrame1 = SOfficeFactory.createTextFrame(this.xTextDoc, 500, 500);
            oFrame2 = SOfficeFactory.createTextFrame(this.xTextDoc, 1500, 1500);
            oPropSet = UnoRuntime.queryInterface(XPropertySet.class, (Object)oFrame1);
            oPropSet.setPropertyValue("AnchorType", TextContentAnchorType.AS_CHARACTER);
            oText = this.xTextDoc.getText();
            oCursor = oText.createTextCursor();
            log.println("inserting Frame1");
            XTextContent the_content = UnoRuntime.queryInterface(XTextContent.class, (Object)oFrame1);
            oText.insertTextContent(oCursor, the_content, true);
            log.println("inserting Frame2");
            the_content = UnoRuntime.queryInterface(XTextContent.class, (Object)oFrame2);
            oText.insertTextContent(oCursor, the_content, true);
            XText oFrameText = oFrame1.getText();
            oFrameText.insertString(oFrameText.getStart(), "The FrameText", true);
            instance = SOF.createInstance(this.xTextDoc, "com.sun.star.text.TextFrame");
        }
        catch (Exception Ex) {
            Ex.printStackTrace(log);
            throw new StatusException("Couldn't insert TextFrame ", Ex);
        }
        oObj = oFrame1;
        log.println("creating a new environment for TextFrame object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("CONTENT", UnoRuntime.queryInterface(XTextContent.class, instance));
        tEnv.addObjRelation("RANGE", this.xTextDoc.getText().createTextCursor());
        log.println("adding ObjRelation for XShape (get/setPosition won't work there)");
        tEnv.addObjRelation("NoPos", "SwXTextFrame");
        tEnv.addObjRelation("NoSetSize", "SwXTextFrame");
        tEnv.addObjRelation("TextFrame", oFrame2);
        return tEnv;
    }
}

