/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextEmbeddedObjectsSupplier;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXTextEmbeddedObjects
extends TestCase {
    XTextDocument oDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            this.oDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn?t create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.oDoc);
    }

    @Override
    public TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XNameAccess oObj = null;
        XTextCursor xCursor = this.oDoc.getText().createTextCursor();
        try {
            XMultiServiceFactory xMultiServiceFactory = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.oDoc);
            Object o = xMultiServiceFactory.createInstance("com.sun.star.text.TextEmbeddedObject");
            XTextContent xTextContent = UnoRuntime.queryInterface(XTextContent.class, o);
            String sChartClassID = "12dcae26-281f-416f-a234-c3086127382e";
            XPropertySet xPropertySet = UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextContent);
            xPropertySet.setPropertyValue("CLSID", sChartClassID);
            this.oDoc.getText().insertTextContent(xCursor, xTextContent, false);
        }
        catch (Exception e) {
            e.printStackTrace(log);
        }
        XTextEmbeddedObjectsSupplier oTEOS = UnoRuntime.queryInterface(XTextEmbeddedObjectsSupplier.class, (Object)this.oDoc);
        oObj = oTEOS.getEmbeddedObjects();
        TestEnvironment tEnv = new TestEnvironment(oObj);
        return tEnv;
    }
}

