/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextEmbeddedObjectsSupplier;
import com.sun.star.text.XTextFrame;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class SwXTextEmbeddedObject
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        try {
            XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)this.xTextDoc);
            closer.close(true);
        }
        catch (CloseVetoException e) {
            log.println("couldn't close document");
        }
        catch (DisposedException e) {
            log.println("couldn't close document");
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XInterface oObj = null;
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't open document", e);
        }
        XTextCursor xCursor = this.xTextDoc.getText().createTextCursor();
        try {
            XMultiServiceFactory xMultiServiceFactory = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
            Object o = xMultiServiceFactory.createInstance("com.sun.star.text.TextEmbeddedObject");
            XTextContent xTextContent = UnoRuntime.queryInterface(XTextContent.class, o);
            String sChartClassID = "12dcae26-281f-416f-a234-c3086127382e";
            XPropertySet xPropertySet = UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextContent);
            xPropertySet.setPropertyValue("CLSID", sChartClassID);
            this.xTextDoc.getText().insertTextContent(xCursor, xTextContent, false);
        }
        catch (Exception e) {
            e.printStackTrace(log);
        }
        XTextEmbeddedObjectsSupplier oTEOS = UnoRuntime.queryInterface(XTextEmbeddedObjectsSupplier.class, (Object)this.xTextDoc);
        XNameAccess oEmObj = oTEOS.getEmbeddedObjects();
        XIndexAccess oEmIn = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oEmObj);
        try {
            oObj = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)oEmIn.getByIndex(0));
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get Object", e);
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("NoAttach", "SwXTextEmbeddedObject");
        XTextFrame aFrame = SOfficeFactory.createTextFrame(this.xTextDoc, 500, 500);
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        XTextContent the_content = UnoRuntime.queryInterface(XTextContent.class, (Object)aFrame);
        try {
            oText.insertTextContent(oCursor, the_content, true);
        }
        catch (IllegalArgumentException e) {
            log.println("Couldn't insert frame " + e.getMessage());
        }
        tEnv.addObjRelation("TextFrame", aFrame);
        tEnv.addObjRelation("NoSetSize", "SwXTextEmbeddedObject");
        tEnv.addObjRelation("NoPos", "SwXTextEmbeddedObject");
        return tEnv;
    }
}

