/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFrame;
import com.sun.star.text.XTextSection;
import com.sun.star.text.XTextSectionsSupplier;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XWordCursor;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.view.XSelectionSupplier;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.WriterTools;

public class SwXTextDocument
extends TestCase {
    XTextDocument xTextDoc;
    XTextDocument xSecondTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xSecondTextDoc);
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XText oText;
        TestEnvironment tEnv = null;
        XTextTable the_table = null;
        try {
            log.println("creating a textdocument");
            this.xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)Param.getMSF());
            oText = this.xTextDoc.getText();
            XTextCursor oCursor = oText.createTextCursor();
            log.println("inserting some lines");
            try {
                int i;
                for (i = 0; i < 5; ++i) {
                    oText.insertString(oCursor, "Paragraph Number: " + i, false);
                    oText.insertString(oCursor, " The quick brown fox jumps over the lazy Dog: SwXParagraph", false);
                    oText.insertControlCharacter(oCursor, (short)0, false);
                    oText.insertString(oCursor, "THE QUICK BROWN FOX JUMPS OVER THE LAZY DOG: SwXParagraph", false);
                    oText.insertControlCharacter(oCursor, (short)0, false);
                    oText.insertControlCharacter(oCursor, (short)1, false);
                }
                for (i = 0; i < 11; ++i) {
                    oText.insertString(oCursor, "xTextDoc ", false);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace(log);
                throw new StatusException("Couldn't insert lines", e);
            }
            XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
            XTextSectionsSupplier oTSSupp = UnoRuntime.queryInterface(XTextSectionsSupplier.class, (Object)this.xTextDoc);
            XNameAccess oTSSuppName = oTSSupp.getTextSections();
            XInterface oTS = (XInterface)oDocMSF.createInstance("com.sun.star.text.TextSection");
            XTextContent oTSC = UnoRuntime.queryInterface(XTextContent.class, (Object)oTS);
            oText.insertTextContent(oCursor, oTSC, false);
            XWordCursor oWordC = UnoRuntime.queryInterface(XWordCursor.class, (Object)oCursor);
            oCursor.setString("End of TextSection");
            oCursor.gotoStart(false);
            oCursor.setString("Start of TextSection ");
            oWordC.gotoEndOfWord(false);
            XInterface oTS2 = (XInterface)oDocMSF.createInstance("com.sun.star.text.TextSection");
            oTSC = UnoRuntime.queryInterface(XTextContent.class, (Object)oTS2);
            oText.insertTextContent(oCursor, oTSC, false);
            XIndexAccess oTSSuppIndex = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oTSSuppName);
            log.println("getting a TextSection with the XTextSectionSupplier()");
            XTextSection xTS = UnoRuntime.queryInterface(XTextSection.class, oTSSuppIndex.getByIndex(0));
            XNamed xTSName = UnoRuntime.queryInterface(XNamed.class, (Object)xTS);
            xTSName.setName("SwXTextSection");
            log.println("    adding TextTable");
            the_table = SOfficeFactory.createTextTable(this.xTextDoc, 6, 4);
            XNamed the_name = UnoRuntime.queryInterface(XNamed.class, (Object)the_table);
            the_name.setName("SwXTextDocument");
            SOfficeFactory.insertTextContent(this.xTextDoc, the_table);
            log.println("    adding ReferenceMark");
            XInterface aMark = (XInterface)oDocMSF.createInstance("com.sun.star.text.ReferenceMark");
            the_name = UnoRuntime.queryInterface(XNamed.class, (Object)aMark);
            the_name.setName("SwXTextDocument");
            XTextContent oTC = UnoRuntime.queryInterface(XTextContent.class, (Object)aMark);
            SOfficeFactory.insertTextContent(this.xTextDoc, oTC);
            log.println("    adding TextGraphic");
            WriterTools.insertTextGraphic(this.xTextDoc, oDocMSF, 5200, 4200, 4400, 4000, "space-metal.jpg", "SwXTextDocument");
            log.println("    adding EndNote");
            XInterface aEndNote = (XInterface)oDocMSF.createInstance("com.sun.star.text.Endnote");
            oTC = UnoRuntime.queryInterface(XTextContent.class, (Object)aEndNote);
            SOfficeFactory.insertTextContent(this.xTextDoc, oTC);
            log.println("    adding Bookmark");
            SOfficeFactory.insertTextContent(this.xTextDoc, SOfficeFactory.createBookmark(this.xTextDoc));
            log.println("    adding DocumentIndex");
            oTC = SOfficeFactory.createIndex(this.xTextDoc, "com.sun.star.text.DocumentIndex");
            SOfficeFactory.insertTextContent(this.xTextDoc, oTC);
            log.println("    adding TextFrame");
            XTextFrame frame = SOfficeFactory.createTextFrame(this.xTextDoc, 500, 500);
            oTC = UnoRuntime.queryInterface(XTextContent.class, (Object)frame);
            SOfficeFactory.insertTextContent(this.xTextDoc, oTC);
            log.println("creating a second textdocument");
            this.xSecondTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)Param.getMSF());
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        if (this.xTextDoc != null) {
            log.println("Creating instance...");
            oText = this.xTextDoc.getText();
            XTextCursor oTextCursor = oText.createTextCursor();
            for (int i = 0; i < 11; ++i) {
                oText.insertString(oTextCursor, "xTextDoc ", false);
            }
        } else {
            log.println("Failed to create instance.");
            return tEnv;
        }
        tEnv = new TestEnvironment(this.xTextDoc);
        XModel model1 = UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
        XModel model2 = UnoRuntime.queryInterface(XModel.class, (Object)this.xSecondTextDoc);
        XController cont1 = model1.getCurrentController();
        XController cont2 = model2.getCurrentController();
        cont1.getFrame().setName("cont1");
        cont2.getFrame().setName("cont2");
        XSelectionSupplier sel = UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)cont1);
        log.println("Adding SelectionSupplier and Shape to select for XModel");
        tEnv.addObjRelation("SELSUPP", sel);
        tEnv.addObjRelation("TOSELECT", the_table);
        log.println("adding Controller as ObjRelation for XModel");
        tEnv.addObjRelation("CONT1", cont1);
        tEnv.addObjRelation("CONT2", cont2);
        return tEnv;
    }
}

