/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.Property;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import ifc.util._XSortable;
import java.io.PrintWriter;
import java.util.Vector;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXTextCursor
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XTextCursor textCursor;
        XTextCursor oObj = null;
        log.println("creating a test environment");
        log.println("getting the TextCursor");
        final XText aText = this.xTextDoc.getText();
        oObj = textCursor = aText.createTextCursor();
        log.println("inserting some text");
        try {
            for (int i = 0; i < 3; ++i) {
                aText.insertString(textCursor, "" + (3 - i), false);
                for (int j = 0; j < 5; ++j) {
                    aText.insertString(textCursor, "XTextCursor,XTextCursor", false);
                    aText.insertString(textCursor, "The quick brown fox ", false);
                    aText.insertString(textCursor, "jumps over the lazy dog ", false);
                }
                aText.insertControlCharacter(textCursor, (short)0, false);
                aText.insertControlCharacter(textCursor, (short)1, false);
            }
        }
        catch (IllegalArgumentException e) {
            log.println("Error, insert text to text document.");
            e.printStackTrace(log);
        }
        log.println("creating a new environment for SwXTextCursor object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("XTEXT", this.xTextDoc.getText());
        XPropertySet xCursorProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)oObj);
        tEnv.addObjRelation("PropertyNames", this.getPropertyNames(xCursorProp));
        final XParagraphCursor paragrCursor = UnoRuntime.queryInterface(XParagraphCursor.class, (Object)oObj);
        final PrintWriter finalLog = log;
        tEnv.addObjRelation("SORTCHECKER", new _XSortable.XSortChecker(){
            PrintWriter out;
            {
                this.out = finalLog;
            }

            @Override
            public void setPrintWriter(PrintWriter log) {
                this.out = log;
            }

            @Override
            public void prepareToSort() {
                textCursor.gotoEnd(false);
                try {
                    aText.insertControlCharacter(textCursor, (short)0, false);
                    aText.insertString(textCursor, "4", false);
                    aText.insertControlCharacter(textCursor, (short)0, false);
                    aText.insertString(textCursor, "b", false);
                    aText.insertControlCharacter(textCursor, (short)0, false);
                    aText.insertString(textCursor, "3", false);
                    aText.insertControlCharacter(textCursor, (short)0, false);
                    aText.insertString(textCursor, "a", false);
                    aText.insertControlCharacter(textCursor, (short)0, false);
                    aText.insertString(textCursor, "23", false);
                    aText.insertControlCharacter(textCursor, (short)0, false);
                    aText.insertString(textCursor, "ab", false);
                    aText.insertControlCharacter(textCursor, (short)0, false);
                }
                catch (IllegalArgumentException e) {
                    this.out.println("Unexpected exception:" + e);
                }
                this.out.println("Preparing cursor to sorting. Text before sorting:");
                paragrCursor.gotoEnd(true);
                for (int i = 0; i < 6; ++i) {
                    paragrCursor.gotoPreviousParagraph(true);
                }
                this.out.println(textCursor.getString());
            }

            @Override
            public boolean checkSort(boolean isSortNumbering, boolean isSortAscending) {
                this.out.println("Sort checking...");
                String ls = System.getProperty("line.separator");
                String text = paragrCursor.getString();
                this.out.println("Text after sorting:\n" + text);
                boolean res = false;
                if (isSortNumbering) {
                    if (isSortAscending) {
                        res = text.endsWith(ls + "3" + ls + "4" + ls + "23");
                        if (!res) {
                            this.out.println("Text must ends by:\n\r\n3\r\n4\r\n23\r\n");
                        }
                    } else {
                        res = text.startsWith("23" + ls + "4" + ls + "3" + ls);
                        if (!res) {
                            this.out.println("Text must starts with:\n23\r\n4\r\n3\r\n");
                        }
                    }
                } else if (isSortAscending) {
                    res = text.equals(ls + "23" + ls + "3" + ls + "4" + ls + "a" + ls + "ab" + ls + "b");
                    if (!res) {
                        this.out.println("Text must be equal to:\n\r\n23\r\n3\r\n4\r\na\r\nab\r\nb\r\n");
                    }
                } else {
                    res = text.endsWith("b" + ls + "ab" + ls + "a" + ls + "4" + ls + "3" + ls + "23" + ls);
                    if (!res) {
                        this.out.println("Text must be equal to:\nb\r\nab\r\na\r\n4\r\n3\r\n23\r\n");
                    }
                }
                if (res) {
                    this.out.println("Sorted correctly");
                }
                return res;
            }
        });
        return tEnv;
    }

    public String[] getPropertyNames(XPropertySet props) {
        Property[] the_props = props.getPropertySetInfo().getProperties();
        Vector<String> names = new Vector<String>();
        for (int i = 0; i < the_props.length; ++i) {
            boolean isWritable;
            boolean bl = isWritable = (the_props[i].Attributes & 0x10) == 0;
            if (!isWritable) continue;
            names.add(the_props[i].Name);
        }
        return names.toArray(new String[names.size()]);
    }
}

