/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XText;
import com.sun.star.text.XTextColumns;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXTextColumns
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XTextColumns oObj = null;
        TestEnvironment tEnv = null;
        XNamed oStyle = null;
        log.println("creating a test environment");
        log.println("getting PageStyle");
        XStyleFamiliesSupplier oSFS = UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)this.xTextDoc);
        XNameAccess oSF = oSFS.getStyleFamilies();
        XIndexAccess oSFIA = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSF);
        try {
            XNameAccess oSFNA = (XNameAccess)AnyConverter.toObject((Type)new Type(XNameAccess.class), (Object)oSFIA.getByIndex(2));
            oStyle = (XStyle)AnyConverter.toObject((Type)new Type(XStyle.class), (Object)oSFNA.getByName("Standard"));
        }
        catch (WrappedTargetException e) {
            log.println("Error, exception occured while getting style.");
            e.printStackTrace(log);
        }
        catch (IndexOutOfBoundsException e) {
            log.println("Error, exception occured while getting style.");
            e.printStackTrace(log);
        }
        catch (NoSuchElementException e) {
            log.println("Error, exception occured while getting style.");
            e.printStackTrace(log);
        }
        catch (IllegalArgumentException e) {
            log.println("Error, exception occured while getting style.");
            e.printStackTrace(log);
        }
        try {
            log.println("Getting property ('TextColumns') value of style " + oStyle.getName());
            XPropertySet xProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)oStyle);
            oObj = (XTextColumns)AnyConverter.toObject((Type)new Type(XTextColumns.class), (Object)xProps.getPropertyValue("TextColumns"));
        }
        catch (WrappedTargetException e) {
            log.println("Exception occured while getting style property");
            e.printStackTrace(log);
        }
        catch (UnknownPropertyException e) {
            log.println("Exception occured while getting style property");
            e.printStackTrace(log);
        }
        catch (IllegalArgumentException e) {
            log.println("Exception occured while getting style property");
            e.printStackTrace(log);
        }
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        log.println("inserting some text to text document...");
        try {
            for (int i = 0; i < 5; ++i) {
                oText.insertString(oCursor, "Paragraph Number: " + i, false);
                oText.insertString(oCursor, "The quick brown fox jumps over the lazy Dog: SwXParagraph", false);
                oText.insertControlCharacter(oCursor, (short)0, false);
                oText.insertString(oCursor, "THE QUICK BROWN FOX JUMPS OVER THE LAZY DOG: SwXParagraph", false);
                oText.insertControlCharacter(oCursor, (short)0, false);
                oText.insertControlCharacter(oCursor, (short)1, false);
            }
        }
        catch (IllegalArgumentException e) {
            log.println("Exception occured while inserting Text");
            e.printStackTrace(log);
        }
        log.println("creating a new environment for object");
        tEnv = new TestEnvironment(oObj);
        return tEnv;
    }
}

