/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableColumns;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXTableColumns
extends TestCase {
    XTextDocument xTextDoc;
    SOfficeFactory SOF;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        this.SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = this.SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XTableColumns oObj = null;
        XTextTable oTable = null;
        log.println("creating a test environment");
        try {
            oTable = SOfficeFactory.createTextTable(this.xTextDoc);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create TextTable: " + e.getMessage(), e);
        }
        try {
            SOfficeFactory.insertTextContent(this.xTextDoc, oTable);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert text content: " + e.getMessage(), e);
        }
        oObj = oTable.getColumns();
        log.println("creating a new environment for TableColumns object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("XTableColumns.XCellRange", UnoRuntime.queryInterface(XCellRange.class, (Object)oTable));
        tEnv.addObjRelation("XIndexAccess.getByIndex.mustBeNull", new Boolean(true));
        return tEnv;
    }
}

