/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.table.XCell;
import com.sun.star.text.XSimpleText;
import com.sun.star.text.XText;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.InstCreator;
import util.ParagraphDsc;
import util.SOfficeFactory;
import util.TextSectionDsc;

public class SwXTableCellText
extends TestCase {
    XTextDocument xTextDoc;
    SOfficeFactory SOF;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        this.SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = this.SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XText oObj = null;
        XTextTable oTable = null;
        log.println("Creating a test environment");
        try {
            oTable = SOfficeFactory.createTextTable(this.xTextDoc);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create TextTable : " + e.getMessage(), e);
        }
        try {
            SOfficeFactory.insertTextContent(this.xTextDoc, oTable);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert text content : " + e.getMessage(), e);
        }
        XCell oCell = oTable.getCellByName("A1");
        XSimpleText oCellText = UnoRuntime.queryInterface(XSimpleText.class, (Object)oCell);
        oCellText.setString("SwXTableCellText");
        oObj = oCellText.getText();
        log.println("creating a new environment for Cell object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("adding TextDocument as mod relation to environment");
        tEnv.addObjRelation("TEXT", oObj);
        log.println("    adding InstCreator object");
        TextSectionDsc tDsc = new TextSectionDsc();
        tEnv.addObjRelation("XTEXTINFO", new InstCreator(this.xTextDoc, tDsc));
        log.println("    adding Paragraph");
        ParagraphDsc pDsc = new ParagraphDsc();
        tEnv.addObjRelation("PARA", new InstCreator(this.xTextDoc, pDsc));
        return tEnv;
    }
}

