/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXStyleFamily
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XNameAccess oSFNA = null;
        log.println("Creating Test Environment...");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        XComponent xComp = UnoRuntime.queryInterface(XComponent.class, (Object)this.xTextDoc);
        XInterface oInstance = (XInterface)SOF.createInstance(xComp, "com.sun.star.style.CharacterStyle");
        XStyleFamiliesSupplier oSFsS = UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)this.xTextDoc);
        XNameAccess oSF = oSFsS.getStyleFamilies();
        XIndexAccess oSFIA = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSF);
        try {
            oSFNA = (XNameAccess)AnyConverter.toObject((Type)new Type(XNameAccess.class), (Object)oSFIA.getByIndex(0));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Unexpected exception. ", e);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Unexpected exception. ", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Unexpected exception. ", e);
        }
        XNameContainer oContainer = UnoRuntime.queryInterface(XNameContainer.class, (Object)oSFNA);
        try {
            oContainer.insertByName("SwXStyleFamily", oInstance);
        }
        catch (WrappedTargetException e) {
            log.println("Could not insert style family.");
            e.printStackTrace(log);
        }
        catch (IllegalArgumentException e) {
            log.println("Could not insert style family.");
            e.printStackTrace(log);
        }
        catch (ElementExistException e) {
            log.println("Could not insert style family.");
            e.printStackTrace(log);
        }
        TestEnvironment tEnv = new TestEnvironment(oSFNA);
        int THRCNT = 1;
        if ((String)Param.get("THRCNT") != null) {
            THRCNT = Integer.parseInt((String)Param.get("THRCNT"));
        }
        String nr = new Integer(THRCNT + 1).toString();
        log.println("adding NameReplaceIndex as mod relation to environment");
        tEnv.addObjRelation("XNameReplaceINDEX", nr);
        for (int n = 1; n < THRCNT + 3; ++n) {
            log.println("adding INSTANCE" + n + " as mod relation to environment");
            tEnv.addObjRelation("INSTANCE" + n, SOF.createInstance(xComp, "com.sun.star.style.CharacterStyle"));
        }
        log.println("adding NAMEREPLACE as mod relation to environment");
        tEnv.addObjRelation("NAMEREPLACE", "SwXStyleFamily");
        return tEnv;
    }
}

