/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXShape
extends TestCase {
    XTextDocument xTextDoc;
    SOfficeFactory SOF;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        this.SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = this.SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XShape oObj = null;
        XDrawPage oDP = null;
        XShapes oShapes = null;
        log.println("creating a test environment");
        log.println("getting Drawpage");
        XDrawPageSupplier oDPS = UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)this.xTextDoc);
        oDP = oDPS.getDrawPage();
        log.println("getting Shape");
        oShapes = UnoRuntime.queryInterface(XShapes.class, (Object)oDP);
        oObj = this.SOF.createShape(this.xTextDoc, 5000, 3500, 7500, 5000, "Rectangle");
        oShapes.add(oObj);
        for (int i = 0; i < 9; ++i) {
            XShape oShape = this.SOF.createShape(this.xTextDoc, 5000 + 100 * i, 3500, 7500, 5000, "Rectangle");
            oShapes.add(oShape);
        }
        log.println("creating a new environment for XShape object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        return tEnv;
    }
}

