/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXParagraphEnumeration
extends TestCase {
    XTextDocument xTextDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XEnumeration oEnum;
        XEnumeration oObj = null;
        log.println("creating a test environment");
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        for (int i = 0; i < 3; ++i) {
            try {
                oText.insertString(oCursor, "Paragraph Number: " + i, false);
                oText.insertControlCharacter(oCursor, (short)1, false);
            }
            catch (IllegalArgumentException e) {
                log.println("EXCEPTION: " + e);
            }
            for (int j = 0; j < 5; ++j) {
                try {
                    oText.insertString(oCursor, "The quick brown fox jumps over the lazy Dog: SwXParagraph", false);
                    oText.insertControlCharacter(oCursor, (short)1, false);
                    oText.insertString(oCursor, "THE QUICK BROWN FOX JUMPS OVER THE LAZY DOG: SwXParagraph", false);
                    oText.insertControlCharacter(oCursor, (short)1, false);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    log.println("EXCEPTION: " + e);
                }
            }
            try {
                oText.insertControlCharacter(oCursor, (short)0, false);
                continue;
            }
            catch (IllegalArgumentException e) {
                log.println("EXCEPTION: " + e);
            }
        }
        XEnumerationAccess oEnumA = UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)oText);
        oObj = oEnum = oEnumA.createEnumeration();
        log.println("creating a new environment for ParagraphEnumeration object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("ENUM", oEnumA);
        return tEnv;
    }
}

