/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class SwXParagraph
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        try {
            XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)this.xTextDoc);
            closer.close(true);
        }
        catch (CloseVetoException e) {
            log.println("couldn't close document");
        }
        catch (DisposedException e) {
            log.println("couldn't close document");
        }
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        if (this.xTextDoc != null) {
            log.println("    disposing xTextDoc ");
            try {
                XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)this.xTextDoc);
                closer.close(true);
            }
            catch (CloseVetoException e) {
                log.println("couldn't close document");
            }
            catch (DisposedException e) {
                log.println("couldn't close document");
            }
        }
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        XInterface oObj = null;
        XPropertySet paraP = null;
        XPropertySet portP = null;
        Object nRules = null;
        XInterface port = null;
        XInterface para = null;
        log.println("creating a test environment");
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        log.println("inserting some lines");
        try {
            for (int i = 0; i < 5; ++i) {
                oText.insertString(oCursor, "Paragraph Number: " + i, false);
                oText.insertString(oCursor, " The quick brown fox jumps over the lazy Dog: SwXParagraph", false);
                oText.insertControlCharacter(oCursor, (short)0, false);
                oText.insertString(oCursor, "THE QUICK BROWN FOX JUMPS OVER THE LAZY DOG: SwXParagraph", false);
                oText.insertControlCharacter(oCursor, (short)0, false);
                oText.insertControlCharacter(oCursor, (short)1, false);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert lines", e);
        }
        XEnumerationAccess oEnumA = UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)oText);
        XEnumeration oEnum = oEnumA.createEnumeration();
        try {
            para = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)oEnum.nextElement());
            XEnumerationAccess oEnumB = UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)para);
            XEnumeration oEnum2 = oEnumB.createEnumeration();
            port = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)oEnum2.nextElement());
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            log.println("Error: exception occured...");
        }
        catch (NoSuchElementException e) {
            e.printStackTrace(log);
            log.println("Error: exception occured...");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            log.println("Error: exception occured...");
        }
        try {
            portP = UnoRuntime.queryInterface(XPropertySet.class, port);
            paraP = UnoRuntime.queryInterface(XPropertySet.class, (Object)para);
            paraP.setPropertyValue("NumberingStyleName", "Numbering 4");
            nRules = paraP.getPropertyValue("NumberingRules");
        }
        catch (WrappedTargetException e) {
            log.println("Error, exception occured...");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get Paragraph", e);
        }
        catch (IllegalArgumentException e) {
            log.println("Error, exception occured...");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get Paragraph", e);
        }
        catch (UnknownPropertyException e) {
            log.println("Error, exception occured...");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get Paragraph", e);
        }
        catch (PropertyVetoException e) {
            log.println("Error, exception occured...");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get Paragraph", e);
        }
        try {
            oObj = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)oEnum.nextElement());
        }
        catch (Exception e) {
            log.println("Error, exception occured...");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get Paragraph", e);
        }
        log.println("creating a new environment for Paragraph object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("adding ObjectRelation 'PARA' for CharacterProperties");
        tEnv.addObjRelation("PARA", paraP);
        log.println("adding ObjectRelation 'PORTION' for CharacterProperties");
        tEnv.addObjRelation("PORTION", portP);
        log.println("adding ObjectRelation 'NRULES' for ParagraphProperties");
        tEnv.addObjRelation("NRULES", nRules);
        tEnv.addObjRelation("NoAttach", "SwXParagraph");
        return tEnv;
    }
}

