/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.NamedValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XDataSource;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XRowSet;
import com.sun.star.sdbcx.XRowLocate;
import com.sun.star.task.XJob;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DBTools;
import util.utils;

public class SwXMailMerge
extends TestCase {
    @Override
    public void initialize(TestParameters Param, PrintWriter log) {
        if (!Param.containsKey("uniqueSuffix")) {
            Param.put("uniqueSuffix", new Integer(0));
        }
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        XInterface oRowSet = null;
        Object oConnection = null;
        XJob Job2 = null;
        log.println(" instantiate MailMerge service");
        try {
            oObj = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.text.MailMerge");
        }
        catch (Exception e) {
            throw new StatusException("Can't create object environment", e);
        }
        String cTestDoc = utils.getFullTestURL("MailMerge.sxw");
        String cOutputURL = utils.getOfficeTemp((XMultiServiceFactory)Param.getMSF());
        String cDataSourceName = "Bibliography";
        String cDataCommand = "biblio";
        Object[] sel = new Object[]{new int[2], new int[5]};
        Object[] myBookMarks = new Object[2];
        log.println("create a XResultSet");
        try {
            oRowSet = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.sdb.RowSet");
        }
        catch (Exception e) {
            throw new StatusException("Can't create com.sun.star.sdb.RowSet", e);
        }
        XPropertySet oRowSetProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)oRowSet);
        XRowSet xRowSet = UnoRuntime.queryInterface(XRowSet.class, (Object)oRowSet);
        try {
            oRowSetProps.setPropertyValue("DataSourceName", cDataSourceName);
            oRowSetProps.setPropertyValue("Command", cDataCommand);
            oRowSetProps.setPropertyValue("CommandType", new Integer(0));
        }
        catch (UnknownPropertyException e) {
            throw new StatusException("Can't set properties on oRowSet", e);
        }
        catch (PropertyVetoException e) {
            throw new StatusException("Can't set properties on oRowSet", e);
        }
        catch (IllegalArgumentException e) {
            throw new StatusException("Can't set properties on oRowSet", e);
        }
        catch (WrappedTargetException e) {
            throw new StatusException("Can't set properties on oRowSet", e);
        }
        try {
            xRowSet.execute();
        }
        catch (SQLException e) {
            throw new StatusException("Can't execute oRowSet", e);
        }
        XResultSet oResultSet = UnoRuntime.queryInterface(XResultSet.class, (Object)oRowSet);
        log.println("create bookmarks");
        try {
            XRowLocate oRowLocate = UnoRuntime.queryInterface(XRowLocate.class, (Object)oResultSet);
            oResultSet.first();
            myBookMarks[0] = oRowLocate.getBookmark();
            oResultSet.next();
            myBookMarks[1] = oRowLocate.getBookmark();
        }
        catch (SQLException e) {
            throw new StatusException("Cant get Bookmarks", e);
        }
        log.println("fill MailMerge with default connection");
        XPropertySet oObjProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)oObj);
        try {
            oObjProps.setPropertyValue("ActiveConnection", this.getLocalXConnection(Param));
            oObjProps.setPropertyValue("DataSourceName", cDataSourceName);
            oObjProps.setPropertyValue("Command", cDataCommand);
            oObjProps.setPropertyValue("CommandType", new Integer(0));
            oObjProps.setPropertyValue("OutputType", new Short(2));
            oObjProps.setPropertyValue("DocumentURL", cTestDoc);
            oObjProps.setPropertyValue("OutputURL", cOutputURL);
            oObjProps.setPropertyValue("FileNamePrefix", "Author");
            oObjProps.setPropertyValue("FileNameFromColumn", new Boolean(false));
            oObjProps.setPropertyValue("Selection", new Object[0]);
        }
        catch (UnknownPropertyException e) {
            throw new StatusException("Can't set properties on oObj", e);
        }
        catch (PropertyVetoException e) {
            throw new StatusException("Can't set properties on oObj", e);
        }
        catch (IllegalArgumentException e) {
            throw new StatusException("Can't set properties on oObj", e);
        }
        catch (WrappedTargetException e) {
            throw new StatusException("Can't set properties on oObj", e);
        }
        Object[] vXJobArgs = new Object[4];
        NamedValue[] vXJobArg0 = new NamedValue[8];
        NamedValue[] vXJobArg1 = new NamedValue[7];
        NamedValue[] vXJobArg2 = new NamedValue[10];
        NamedValue[] vXJobArg3 = new NamedValue[]{};
        vXJobArg0[0] = new NamedValue("DataSourceName", cDataSourceName);
        vXJobArg0[1] = new NamedValue("Command", cDataCommand);
        vXJobArg0[2] = new NamedValue("CommandType", new Integer(0));
        vXJobArg0[3] = new NamedValue("OutputType", new Short(2));
        vXJobArg0[4] = new NamedValue("DocumentURL", cTestDoc);
        vXJobArg0[5] = new NamedValue("OutputURL", cOutputURL);
        vXJobArg0[6] = new NamedValue("FileNamePrefix", "Identifier");
        vXJobArg0[7] = new NamedValue("FileNameFromColumn", new Boolean(true));
        vXJobArg1[0] = new NamedValue("DataSourceName", cDataSourceName);
        vXJobArg1[1] = new NamedValue("Command", cDataCommand);
        vXJobArg1[2] = new NamedValue("CommandType", new Integer(0));
        vXJobArg1[3] = new NamedValue("OutputType", new Short(1));
        vXJobArg1[4] = new NamedValue("DocumentURL", cTestDoc);
        vXJobArg1[5] = new NamedValue("FileNamePrefix", "Author");
        vXJobArg1[6] = new NamedValue("FileNameFromColumn", new Boolean(true));
        vXJobArg2[0] = new NamedValue("ActiveConnection", this.getLocalXConnection(Param));
        vXJobArg2[1] = new NamedValue("DataSourceName", cDataSourceName);
        vXJobArg2[2] = new NamedValue("Command", cDataCommand);
        vXJobArg2[3] = new NamedValue("CommandType", new Integer(0));
        vXJobArg2[4] = new NamedValue("OutputType", new Short(2));
        vXJobArg2[5] = new NamedValue("ResultSet", oResultSet);
        vXJobArg2[6] = new NamedValue("OutputURL", cOutputURL);
        vXJobArg2[7] = new NamedValue("FileNamePrefix", "Identifier");
        vXJobArg2[8] = new NamedValue("FileNameFromColumn", new Boolean(true));
        vXJobArg2[9] = new NamedValue("Selection", myBookMarks);
        vXJobArgs[0] = vXJobArg0;
        vXJobArgs[1] = vXJobArg1;
        vXJobArgs[2] = vXJobArg2;
        vXJobArgs[3] = vXJobArg3;
        Job2 = UnoRuntime.queryInterface(XJob.class, (Object)oObj);
        try {
            Job2.execute(vXJobArg2);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.toString());
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        log.println("create XResultSet");
        try {
            oRowSet = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.sdb.RowSet");
        }
        catch (Exception e) {
            throw new StatusException("Can't create com.sun.star.sdb.RowSet", e);
        }
        oRowSetProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)oRowSet);
        xRowSet = UnoRuntime.queryInterface(XRowSet.class, (Object)oRowSet);
        try {
            oRowSetProps.setPropertyValue("DataSourceName", cDataSourceName);
            oRowSetProps.setPropertyValue("Command", cDataCommand);
            oRowSetProps.setPropertyValue("CommandType", new Integer(0));
        }
        catch (UnknownPropertyException e) {
            throw new StatusException("Can't set properties on oRowSet", e);
        }
        catch (PropertyVetoException e) {
            throw new StatusException("Can't set properties on oRowSet", e);
        }
        catch (IllegalArgumentException e) {
            throw new StatusException("Can't set properties on oRowSet", e);
        }
        catch (WrappedTargetException e) {
            throw new StatusException("Can't set properties on oRowSet", e);
        }
        try {
            xRowSet.execute();
        }
        catch (SQLException e) {
            throw new StatusException("Can't execute oRowSet", e);
        }
        oResultSet = UnoRuntime.queryInterface(XResultSet.class, (Object)oRowSet);
        XResultSet oMMXResultSet = null;
        try {
            oMMXResultSet = UnoRuntime.queryInterface(XResultSet.class, (Object)((XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.sdb.RowSet")));
        }
        catch (Exception e) {
            throw new StatusException("Can't create com.sun.star.sdb.RowSet", e);
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("DataAccessDescriptor.XResultSet", oResultSet);
        tEnv.addObjRelation("DataAccessDescriptor.XConnection", this.getRemoteXConnection(Param));
        tEnv.addObjRelation("MailMerge.XConnection", this.getRemoteXConnection(Param));
        tEnv.addObjRelation("MailMerge.XResultSet", oMMXResultSet);
        tEnv.addObjRelation("executeArgs", vXJobArg0);
        tEnv.addObjRelation("Job", Job2);
        tEnv.addObjRelation("XJobArgs", vXJobArgs);
        return tEnv;
    }

    private XConnection getRemoteXConnection(TestParameters Param) {
        this.log.println("create remote connection");
        String databaseName = null;
        Object oXDataSource = null;
        Object oInterface = null;
        XMultiServiceFactory xMSF = null;
        int uniqueSuffix = Param.getInt("uniqueSuffix");
        try {
            xMSF = (XMultiServiceFactory)Param.getMSF();
            oInterface = xMSF.createInstance("com.sun.star.sdb.DatabaseContext");
            String tmpDatabaseUrl = utils.getOfficeTempDir((XMultiServiceFactory)Param.getMSF());
            databaseName = "NewDatabaseSource" + uniqueSuffix;
            String tmpDatabaseFile = tmpDatabaseUrl + databaseName + ".odb";
            System.out.println("try to delete '" + tmpDatabaseFile + "'");
            utils.deleteFile((XMultiServiceFactory)Param.getMSF(), tmpDatabaseFile);
            tmpDatabaseUrl = "sdbc:dbase:file:///" + tmpDatabaseUrl;
            XInterface newSource = (XInterface)xMSF.createInstance("com.sun.star.sdb.DataSource");
            XPropertySet xSrcProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)newSource);
            xSrcProp.setPropertyValue("URL", tmpDatabaseUrl);
            DBTools dbt = new DBTools((XMultiServiceFactory)Param.getMSF());
            this.log.println("register database '" + tmpDatabaseUrl + "' as '" + databaseName + "'");
            dbt.reRegisterDB(databaseName, newSource);
            Param.put("uniqueSuffix", new Integer(++uniqueSuffix));
            return dbt.connectToSource(newSource);
        }
        catch (Exception e) {
            Param.put("uniqueSuffix", new Integer(++uniqueSuffix));
            this.log.println("could not register new database");
            e.printStackTrace();
            throw new StatusException("could not register new database", e);
        }
    }

    private XConnection getLocalXConnection(TestParameters Param) {
        this.log.println("create local connection");
        XInterface oDataCont = null;
        try {
            oDataCont = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.sdb.DatabaseContext");
        }
        catch (Exception e) {
            throw new StatusException("Couldn't create instance of 'com.sun.star.sdb.DatabaseContext'", e);
        }
        XNameAccess xNADataCont = UnoRuntime.queryInterface(XNameAccess.class, (Object)oDataCont);
        String[] dataNames = xNADataCont.getElementNames();
        String dataName = "";
        for (int i = 0; i < dataNames.length; ++i) {
            if (!dataNames[i].startsWith("Biblio")) continue;
            dataName = dataNames[i];
        }
        try {
            Object oDataBase = xNADataCont.getByName(dataName);
            XDataSource xDataSource = UnoRuntime.queryInterface(XDataSource.class, oDataBase);
            return xDataSource.getConnection("", "");
        }
        catch (NoSuchElementException e) {
            throw new StatusException("Couldn't get registered data base", e);
        }
        catch (WrappedTargetException e) {
            throw new StatusException("Couldn't get registered data base", e);
        }
        catch (SQLException e) {
            throw new StatusException("Couldn't get XConnection from registered data base", e);
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("closing connections...");
        XMultiServiceFactory xMsf = (XMultiServiceFactory)Param.getMSF();
        DBTools dbt = new DBTools(xMsf);
        if (Param.containsKey("uniqueSuffix")) {
            int uniqueSuffix = Param.getInt("uniqueSuffix");
            --uniqueSuffix;
            String databaseName = "";
            while (uniqueSuffix >= 0) {
                databaseName = "NewDatabaseSource" + uniqueSuffix;
                log.println("revoke '" + databaseName + "'");
                try {
                    dbt.revokeDB(databaseName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                --uniqueSuffix;
            }
        }
    }
}

