/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XLineNumberingProperties;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.dbg;

public class SwXLineNumberingProperties
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        try {
            for (int i = 0; i < 5; ++i) {
                oText.insertString(oCursor, "The quick brown fox jumps over the lazy Dog", false);
                oText.insertControlCharacter(oCursor, (short)0, false);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            log.println("Exception occured: " + e);
        }
        XLineNumberingProperties oLNP = UnoRuntime.queryInterface(XLineNumberingProperties.class, (Object)this.xTextDoc);
        XPropertySet lineNumProps = oLNP.getLineNumberingProperties();
        dbg.printPropertiesNames(lineNumProps);
        TestEnvironment tEnv = new TestEnvironment(lineNumProps);
        return tEnv;
    }
}

