/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XText;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.InstCreator;
import util.ParagraphDsc;
import util.SOfficeFactory;
import util.TableDsc;

public class SwXHeadFootText
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XText oObj = null;
        XNameAccess PageStyles = null;
        XStyle StdStyle = null;
        log.println("creating a test environment");
        XStyleFamiliesSupplier StyleFam = UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)this.xTextDoc);
        XNameAccess StyleFamNames = StyleFam.getStyleFamilies();
        try {
            PageStyles = (XNameAccess)AnyConverter.toObject((Type)new Type(XNameAccess.class), (Object)StyleFamNames.getByName("PageStyles"));
            StdStyle = (XStyle)AnyConverter.toObject((Type)new Type(XStyle.class), (Object)PageStyles.getByName("Standard"));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting style by name!", e);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace(log);
            throw new StatusException("Error, no such style name! ", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting style by name!", e);
        }
        XPropertySet PropSet = UnoRuntime.queryInterface(XPropertySet.class, (Object)StdStyle);
        try {
            log.println("Switching on header");
            PropSet.setPropertyValue("HeaderIsOn", new Boolean(true));
            log.println("Switching on footer");
            PropSet.setPropertyValue("FooterIsOn", new Boolean(true));
            log.println("Get header text");
            oObj = UnoRuntime.queryInterface(XText.class, PropSet.getPropertyValue("HeaderText"));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't set/get propertyValue...", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't set/get propertyValue...", e);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't set/get propertyValue...", e);
        }
        catch (UnknownPropertyException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't set/get propertyValue...", e);
        }
        log.println("creating a new environment for bodytext object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("    adding Paragraph");
        ParagraphDsc pDsc = new ParagraphDsc();
        tEnv.addObjRelation("PARA", new InstCreator(this.xTextDoc, pDsc));
        log.println("adding InstDescriptor object");
        TableDsc tDsc = new TableDsc(6, 4);
        log.println("adding InstCreator object");
        tEnv.addObjRelation("XTEXTINFO", new InstCreator(this.xTextDoc, tDsc));
        tEnv.addObjRelation("TEXT", oObj);
        return tEnv;
    }
}

