/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XFootnote;
import com.sun.star.text.XSimpleText;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.InstCreator;
import util.ParagraphDsc;
import util.SOfficeFactory;
import util.TextSectionDsc;

public class SwXFootnoteText
extends TestCase {
    XTextDocument xTextDoc;
    SOfficeFactory SOF;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XFootnote oFootnote;
        XText oObj = null;
        log.println("creating a test environment");
        XMultiServiceFactory msf = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
        log.println("creating a footnote");
        try {
            oFootnote = UnoRuntime.queryInterface(XFootnote.class, msf.createInstance("com.sun.star.text.Footnote"));
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create footnote", e);
        }
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        log.println("inserting the footnote into text document");
        try {
            oText.insertTextContent(oCursor, oFootnote, false);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert the footnote", e);
        }
        XSimpleText oFootText = UnoRuntime.queryInterface(XSimpleText.class, (Object)oFootnote);
        oFootText.setString("SwXFootnoteText");
        oObj = oFootText.getText();
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("adding TextDocument as mod relation to environment");
        tEnv.addObjRelation("TEXT", oObj);
        TextSectionDsc tDsc = new TextSectionDsc();
        log.println("    adding InstCreator object");
        tEnv.addObjRelation("XTEXTINFO", new InstCreator(this.xTextDoc, tDsc));
        log.println("    adding Paragraph");
        ParagraphDsc pDsc = new ParagraphDsc();
        tEnv.addObjRelation("PARA", new InstCreator(this.xTextDoc, pDsc));
        return tEnv;
    }
}

