/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XFootnote;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FrameDsc;
import util.InstCreator;
import util.SOfficeFactory;

public class SwXFootnote
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XFootnote oFootnote;
        log.println("Creating a test environment");
        XMultiServiceFactory msf = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
        log.println("creating a footnote");
        Object instance = null;
        try {
            oFootnote = UnoRuntime.queryInterface(XFootnote.class, msf.createInstance("com.sun.star.text.Footnote"));
            instance = msf.createInstance("com.sun.star.text.Footnote");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create footnote", e);
        }
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        log.println("inserting the footnote into text document");
        try {
            oText.insertTextContent(oCursor, oFootnote, false);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert the footnote", e);
        }
        TestEnvironment tEnv = new TestEnvironment(oFootnote);
        tEnv.addObjRelation("CONTENT", UnoRuntime.queryInterface(XTextContent.class, instance));
        tEnv.addObjRelation("RANGE", this.xTextDoc.getText().createTextCursor());
        log.println("adding InstDescriptor object");
        FrameDsc tDsc = new FrameDsc(3000, 6000);
        log.println("adding InstCreator object");
        tEnv.addObjRelation("XTEXTINFO", new InstCreator(this.xTextDoc, tDsc));
        return tEnv;
    }
}

