/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XEndnotesSupplier;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.dbg;

public class SwXEndnoteProperties
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XInterface oEndnote;
        XEndnotesSupplier oInterface = null;
        XPropertySet oObj = null;
        log.println("Creating a test environment");
        XMultiServiceFactory msf = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
        log.println("creating a endnote");
        try {
            oEndnote = UnoRuntime.queryInterface(XInterface.class, msf.createInstance("com.sun.star.text.Endnote"));
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create endnote", e);
        }
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        log.println("inserting the footnote into text document");
        XTextContent xTC = UnoRuntime.queryInterface(XTextContent.class, (Object)oEndnote);
        try {
            oText.insertTextContent(oCursor, xTC, false);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert the endnote", e);
        }
        oInterface = UnoRuntime.queryInterface(XEndnotesSupplier.class, (Object)this.xTextDoc);
        oObj = oInterface.getEndnoteSettings();
        dbg.printPropertiesNames(oObj);
        TestEnvironment tEnv = new TestEnvironment(oObj);
        return tEnv;
    }
}

