/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.drawing.XShapes;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.InstCreator;
import util.SOfficeFactory;
import util.ShapeDsc;

public class SwXDrawPage
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XDrawPage oObj = null;
        XDrawPage xDP = null;
        XShapes oShapes = null;
        log.println("creating a test environment");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        XDrawPageSupplier XDPSupp = UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)this.xTextDoc);
        oObj = xDP = XDPSupp.getDrawPage();
        log.println("inserting some Shapes");
        oShapes = UnoRuntime.queryInterface(XShapes.class, (Object)oObj);
        oShapes.add(SOF.createShape(this.xTextDoc, 2000, 1500, 1000, 1000, "Line"));
        oShapes.add(SOF.createShape(this.xTextDoc, 3000, 4500, 15000, 1000, "Ellipse"));
        oShapes.add(SOF.createShape(this.xTextDoc, 5000, 3500, 7500, 5000, "Rectangle"));
        log.println("creating a new environment for bodytext object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        ShapeDsc sDsc = new ShapeDsc(15000, 13500, 7500, 10000, "Rectangle");
        log.println("adding Shape as mod relation to environment");
        tEnv.addObjRelation("Shape", new InstCreator(this.xTextDoc, sDsc));
        tEnv.addObjRelation("DrawPage", oObj);
        return tEnv;
    }
}

